<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="estados")
 * @ORM\Entity()
 */
class Estados {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=20, unique=true)
     */
    protected $codigo;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $nombre;
    
    /**
     * @ORM\ManyToOne(targetEntity="Pais", inversedBy="estado")
     * @ORM\JoinColumn(name="pais_id", referencedColumnName="id")
     */
    protected $pais;
    
    /**
     * @ORM\OneToMany(targetEntity="Ciudades", mappedBy="estado")
     */
    protected $ciudad;
    
    /**
     * @ORM\OneToMany(targetEntity="Municipios", mappedBy="estado")
     */
    protected $municipio;

    /**
     * @ORM\OneToMany(targetEntity="Estudiante", mappedBy="estado")
     */
    protected $estudiante;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->ciudad = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     * @return Estados
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    
        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     * @return Estados
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    
        return $this;
    }

    /**
     * Get nombre
     *
     * @return string 
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set pais
     *
     * @param \AppBundle\Entity\Pais $pais
     * @return Estados
     */
    public function setPais(\AppBundle\Entity\Pais $pais = null)
    {
        $this->pais = $pais;
    
        return $this;
    }

    /**
     * Get pais
     *
     * @return \AppBundle\Entity\Pais 
     */
    public function getPais()
    {
        return $this->pais;
    }

    /**
     * Add ciudad
     *
     * @param \AppBundle\Entity\Ciudades $ciudad
     * @return Estados
     */
    public function addCiudad(\AppBundle\Entity\Ciudades $ciudad)
    {
        $this->ciudad[] = $ciudad;
    
        return $this;
    }

    /**
     * Remove ciudad
     *
     * @param \AppBundle\Entity\Ciudades $ciudad
     */
    public function removeCiudad(\AppBundle\Entity\Ciudades $ciudad)
    {
        $this->ciudad->removeElement($ciudad);
    }

    /**
     * Get ciudad
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCiudad()
    {
        return $this->ciudad;
    }

    /**
     * Add municipio
     *
     * @param \AppBundle\Entity\Municipios $municipio
     * @return Estados
     */
    public function addMunicipio(\AppBundle\Entity\Municipios $municipio)
    {
        $this->municipio[] = $municipio;
    
        return $this;
    }

    /**
     * Remove municipio
     *
     * @param \AppBundle\Entity\Municipios $municipio
     */
    public function removeMunicipio(\AppBundle\Entity\Municipios $municipio)
    {
        $this->municipio->removeElement($municipio);
    }

    /**
     * Get municipio
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getMunicipio()
    {
        return $this->municipio;
    }

    /**
     * Add estudiante
     *
     * @param \AppBundle\Entity\Estudiante $estudiante
     * @return Estados
     */
    public function addEstudiante(\AppBundle\Entity\Estudiante $estudiante)
    {
        $this->estudiante[] = $estudiante;
    
        return $this;
    }

    /**
     * Remove estudiante
     *
     * @param \AppBundle\Entity\Estudiante $estudiante
     */
    public function removeEstudiante(\AppBundle\Entity\Estudiante $estudiante)
    {
        $this->estudiante->removeElement($estudiante);
    }

    /**
     * Get estudiante
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }
    
     public function __toString() {
        return $this->getNombre();
    }
}
