<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="modalidad")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\ModalidadRepository")
 */

class Modalidad {
    
     /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    
     /**
     * @ORM\Column(type="string", length=50)
     */
    protected $descripcion;

    /**
     * @ORM\OneToMany(targetEntity="OfertAcade", mappedBy="modalidad")
     */    
    protected $ofertacade;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->ofertacade = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set descripcion
     *
     * @param string $descripcion
     *
     * @return Modalidad
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;

        return $this;
    }

    /**
     * Get descripcion
     *
     * @return string
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * Add ofertacade
     *
     * @param \AppBundle\Entity\OfertAcade $ofertacade
     *
     * @return Modalidad
     */
    public function addOfertacade(\AppBundle\Entity\OfertAcade $ofertacade)
    {
        $this->ofertacade[] = $ofertacade;

        return $this;
    }

    /**
     * Remove ofertacade
     *
     * @param \AppBundle\Entity\OfertAcade $ofertacade
     */
    public function removeOfertacade(\AppBundle\Entity\OfertAcade $ofertacade)
    {
        $this->ofertacade->removeElement($ofertacade);
    }

    /**
     * Get ofertacade
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOfertacade()
    {
        return $this->ofertacade;
    }
    
        public function __toString()
    {
        return $this->descripcion;
    }
}
