<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="plan_estudio")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\PlanEstudioRepository")
 */
class PlanEstudio {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */    
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="Cursos", inversedBy="planestudio")
     * @ORM\JoinColumn(name="curso_id", referencedColumnName="id")
     */
    protected $curso;
    
    /**
     * @ORM\Column(type="string", length=20)
     */
    protected $plan;
    
    /**
     * @ORM\Column(type="integer", length=2)
     */
    protected $semestre;
    
    /**
     * @ORM\ManyToOne(targetEntity="Especialidad", inversedBy="planestudio")
     * @ORM\JoinColumn(name="especialidad_id", referencedColumnName="id")
     */
    protected $especialidad;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="planestudio")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
    /**
     * @ORM\ManyToOne(targetEntity="Programa", inversedBy="planestudio")
     * @ORM\JoinColumn(name="programa_id", referencedColumnName="id")
     */
    protected $programa;
    
    /**
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\Prelacion", mappedBy="plan", cascade={"remove"})
     */
    protected $prelacion;
    


    /**
     * @ORM\ManyToOne(targetEntity="Niveles", inversedBy="planestudio")
     * @ORM\JoinColumn(name="nivel_id", referencedColumnName="id")
     */
    protected $niveles;
    




    // METODOS GENERADOS PARA LAS CONSULTA //    

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set plan
     *
     * @param string $plan
     * @return PlanEstudio
     */
    public function setPlan($plan)
    {
        $this->plan = $plan;
    
        return $this;
    }

    /**
     * Get plan
     *
     * @return string 
     */
    public function getPlan()
    {
        return $this->plan;
    }

    /**
     * Set semestre
     *
     * @param integer $semestre
     * @return PlanEstudio
     */
    public function setSemestre($semestre)
    {
        $this->semestre = $semestre;
    
        return $this;
    }

    /**
     * Get semestre
     *
     * @return integer 
     */
    public function getSemestre()
    {
        return $this->semestre;
    }

   

    /**
     * Set curso
     *
     * @param AppBundle\Entity\Cursos $curso
     * @return PlanEstudio
     */
    public function setCurso(\AppBundle\Entity\Cursos $curso = null)
    {
        $this->curso = $curso;
    
        return $this;
    }

    /**
     * Get curso
     *
     * @return AppBundle\Entity\Cursos 
     */
    public function getCurso()
    {
        return $this->curso;
    }

    /**
     * Set especilidad
     *
     * @param AppBundle\Entity\Especialidad $especilidad
     * @return PlanEstudio
     */
    public function setEspecilidad(\AppBundle\Entity\Especialidad $especilidad = null)
    {
        $this->especilidad = $especilidad;
    
        return $this;
    }

    /**
     * Get especilidad
     *
     * @return AppBundle\Entity\Especialidad 
     */
    public function getEspecilidad()
    {
        return $this->especilidad;
    }

    /**
     * Set programa
     *
     * @param AppBundle\Entity\Programa $programa
     * @return PlanEstudio
     */
    public function setPrograma(\AppBundle\Entity\Programa $programa = null)
    {
        $this->programa = $programa;
    
        return $this;
    }

    /**
     * Get programa
     *
     * @return AppBundle\Entity\Programa 
     */
    public function getPrograma()
    {
        return $this->programa;
    }

    /**
     * Set prelacion
     *
     * @param AppBundle\Entity\Cursos $prelacion
     * @return PlanEstudio
     */
    public function setPrelacion(\AppBundle\Entity\Cursos $prelacion = null)
    {
        $this->prelacion = $prelacion;
    
        return $this;
    }

    /**
     * Get prelacion
     *
     * @return AppBundle\Entity\Cursos 
     */
    public function getPrelacion()
    {
        return $this->prelacion;
    }

    /**
     * Set especialidad
     *
     * @param AppBundle\Entity\Especialidad $especialidad
     * @return PlanEstudio
     */
    public function setEspecialidad(\AppBundle\Entity\Especialidad $especialidad = null)
    {
        $this->especialidad = $especialidad;
    
        return $this;
    }

    /**
     * Get especialidad
     *
     * @return AppBundle\Entity\Especialidad 
     */
    public function getEspecialidad()
    {
        return $this->especialidad;
    }

    /**
     * Set sede
     *
     * @param AppBundle\Entity\Sede $sede
     * @return PlanEstudio
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }

    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->prelacion = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Add prelacion
     *
     * @param \AppBundle\Entity\Prelacion $prelacion
     *
     * @return PlanEstudio
     */
    public function addPrelacion(\AppBundle\Entity\Prelacion $prelacion)
    {
        $this->prelacion[] = $prelacion;

        return $this;
    }

    /**
     * Remove prelacion
     *
     * @param \AppBundle\Entity\Prelacion $prelacion
     */
    public function removePrelacion(\AppBundle\Entity\Prelacion $prelacion)
    {
        $this->prelacion->removeElement($prelacion);
    }

    /**
     * Set niveles
     *
     * @param \AppBundle\Entity\Niveles $niveles
     *
     * @return PlanEstudio
     */
    public function setNiveles(\AppBundle\Entity\Niveles $niveles = null)
    {
        $this->niveles = $niveles;

        return $this;
    }

    /**
     * Get niveles
     *
     * @return \AppBundle\Entity\Niveles
     */
    public function getNiveles()
    {
        return $this->niveles;
    }

    
}
