<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="promociones")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\PromocionesRepository")
 */
class Promociones {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=80)
     */
    protected $nombre;
    
    /**
     * @ORM\Column(type="date")
     */
    protected $fechapromocion;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="promocion")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
    /**
     * @ORM\OneToMany(targetEntity="EspeEstud", mappedBy="promocion")
     */
    protected $espeestud;
    
    /**
     * @ORM\OneToMany(targetEntity="HistEgresado", mappedBy="promocion")
     */
    protected $histegresado;
    
   
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->espeestud = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histegresado = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     * @return Promociones
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    
        return $this;
    }

    /**
     * Get nombre
     *
     * @return string 
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set fechapromocion
     *
     * @param \DateTime $fechapromocion
     * @return Promociones
     */
    public function setFechapromocion($fechapromocion)
    {
        $this->fechapromocion = $fechapromocion;
    
        return $this;
    }

    /**
     * Get fechapromocion
     *
     * @return \DateTime 
     */
    public function getFechapromocion()
    {
        return $this->fechapromocion;
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     * @return Promociones
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Add espeestud
     *
     * @param \AppBundle\Entity\EspeEstud $espeestud
     * @return Promociones
     */
    public function addEspeestud(\AppBundle\Entity\EspeEstud $espeestud)
    {
        $this->espeestud[] = $espeestud;
    
        return $this;
    }

    /**
     * Remove espeestud
     *
     * @param \AppBundle\Entity\EspeEstud $espeestud
     */
    public function removeEspeestud(\AppBundle\Entity\EspeEstud $espeestud)
    {
        $this->espeestud->removeElement($espeestud);
    }

    /**
     * Get espeestud
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getEspeestud()
    {
        return $this->espeestud;
    }

    /**
     * Add histegresado
     *
     * @param \AppBundle\Entity\HistEgresado $histegresado
     * @return Promociones
     */
    public function addHistegresado(\AppBundle\Entity\HistEgresado $histegresado)
    {
        $this->histegresado[] = $histegresado;
    
        return $this;
    }

    /**
     * Remove histegresado
     *
     * @param \AppBundle\Entity\HistEgresado $histegresado
     */
    public function removeHistegresado(\AppBundle\Entity\HistEgresado $histegresado)
    {
        $this->histegresado->removeElement($histegresado);
    }

    /**
     * Get histegresado
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHistegresado()
    {
        return $this->histegresado;
    }
    
    public function __toString() {
        return $this->getNombre();
    }
}
