<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

use AppBundle\Entity\Estudiante;

/**
 * RecibosPago
 *
 * @ORM\Table()
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\RecibosPagoRepository")
 */
class RecibosPago
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo_recibo", type="string", length=30)
     */
    private $codigo_recibo;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fecha", type="datetime")
     */
    private $fecha;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_pago", type="string", length=30)
     */
    private $tipo_pago;

    /**
     * @var string
     *
     * @ORM\Column(name="nro_operacion", type="string", length=50)
     */
    private $nro_operacion;

    /**
     * @var string
     *
     * @ORM\Column(name="cedula", type="string", length=12)
     */
    private $cedula;

    /**
     * @var string
     *
     * @ORM\Column(name="concepto", type="string", length=255)
     */
    private $concepto;

    /**
     * @var string
     *
     * @ORM\Column(name="monto", type="decimal", scale=2)
     */
    private $monto;
    /**
     * @var string
     * 
     * @ORM\Column(name="lapso", type="string", length=20)     * 
     */
    protected $lapso;

    /**
     * @ORM\ManyToOne(targetEntity="Estudiante", inversedBy="recibospago")
     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")
     */
    protected $estudiante;
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     * @return RecibosPago
     */
    public function setCodigo($codigo)
    {
        $this->codigo_recibo = $codigo;
    
        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo_recibo;
    }

    /**
     * Set fecha
     *
     * @param \DateTime $fecha
     * @return RecibosPago
     */
    public function setFecha(\DateTime $fecha)
    {
        $this->fecha = $fecha;
    
        return $this;
    }

    /**
     * Get fecha
     *
     * @return \DateTime 
     */
    public function getFecha()
    {
        return $this->fecha;
    }

    /**
     * Set tipo_pago
     *
     * @param string $tipoPago
     * @return RecibosPago
     */
    public function setTipoPago($tipoPago)
    {
        $this->tipo_pago = $tipoPago;
    
        return $this;
    }

    /**
     * Get tipo_pago
     *
     * @return string 
     */
    public function getTipoPago()
    {
        return $this->tipo_pago;
    }

    /**
     * Set nro_operacion
     *
     * @param string $nroOperacion
     * @return RecibosPago
     */
    public function setNroOperacion($nroOperacion)
    {
        $this->nro_operacion = $nroOperacion;
    
        return $this;
    }

    /**
     * Get nro_operacion
     *
     * @return string 
     */
    public function getNroOperacion()
    {
        return $this->nro_operacion;
    }

    /**
     * Set cedula
     *
     * @param string $cedula
     * @return RecibosPago
     */
    public function setCedula($cedula)
    {
        $this->cedula = $cedula;
    
        return $this;
    }

    /**
     * Get cedula
     *
     * @return string 
     */
    public function getCedula()
    {
        return $this->cedula;
    }

    /**
     * Set concepto
     *
     * @param string $concepto
     * @return RecibosPago
     */
    public function setConcepto($concepto)
    {
        $this->concepto = $concepto;
    
        return $this;
    }

    /**
     * Get concepto
     *
     * @return string 
     */
    public function getConcepto()
    {
        return $this->concepto;
    }

    /**
     * Set monto
     *
     * @param string $monto
     * @return RecibosPago
     */
    public function setMonto($monto)
    {
        $this->monto = $monto;
    
        return $this;
    }

    /**
     * Get monto
     *
     * @return string 
     */
    public function getMonto()
    {
        return $this->monto;
    }
    public function __toString() {
        return $this->codigo;
    }
    //hector
    /**
     * Set Estudiante
     *
     * @param \AppBundle\Entity\Estudiante $estudiante     
     */
    public function setEstudiante(Estudiante $estudiante=null)
    {
        $this->estudiante = $estudiante;
    }
    /**
     * Get Estudiante
     *
     * @return \AppBundle\Entity\Estudiante
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }
    /**
     * Set lapso
     *
     * @param string $lapso
     * @return RecibosPago
     */
    public function setLapso($lapso)
    {
        $this->lapso = $lapso;
    
        return $this;
    }

    /**
     * Get lapso
     *
     * @return string 
     */
    public function getLapso()
    {
        return $this->lapso;
    }

    /**
     * Set codigo_recibo
     *
     * @param string $codigoRecibo
     * @return RecibosPago
     */
    public function setCodigoRecibo($codigoRecibo)
    {
        $this->codigo_recibo = $codigoRecibo;
    
        return $this;
    }

    /**
     * Get codigo_recibo
     *
     * @return string 
     */
    public function getCodigoRecibo()
    {
        return $this->codigo_recibo;
    }
}
