<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="estu_validados")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\ValidEstudianteRepository")
 */
class ValidEstudiante {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="EspeEstud", inversedBy="validestud")
     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")
     */
    protected $estudiante;
    
    /**
     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="validestud")
     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")
     */
    protected $lapso;
    
    

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set estudiante
     *
     * @param \AppBundle\Entity\EspeEstud $estudiante
     * @return ValidEstudiante
     */
    public function setEstudiante(\AppBundle\Entity\EspeEstud $estudiante = null)
    {
        $this->estudiante = $estudiante;
    
        return $this;
    }

    /**
     * Get estudiante
     *
     * @return \AppBundle\Entity\EspeEstud 
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }

    /**
     * Set lapso
     *
     * @param \AppBundle\Entity\Lapso $lapso
     * @return ValidEstudiante
     */
    public function setLapso(\AppBundle\Entity\Lapso $lapso = null)
    {
        $this->lapso = $lapso;
    
        return $this;
    }

    /**
     * Get lapso
     *
     * @return \AppBundle\Entity\Lapso 
     */
    public function getLapso()
    {
        return $this->lapso;
    }
}
