<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class DepositosType extends AbstractType
{
    private $em; 
    public function __construct(\Doctrine\ORM\EntityManager $em) {
        $this->em = $em;
    }
    
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('num_deposito', 'integer')
            ->add('monto','number')
            ->add('fecha_deposito', 'date', array(
                'input' => 'datetime',
                'widget'=> 'single_text',
                'format'=> 'dd-MM-yyyy',
                'attr' => array('placeholder' => 'dd-mm-yyyy','readonly'=>'readonly')
             ))
            ->add('file','file', array('required'=>false,'attr'=>array('class'=>'form-control')))
            //->add('estudiante')
            //->add('lapso', 'entity', array(
            //    'class'=>'AppBundle:Lapso',
            //    'em'=>$this->em
            //))
            //->add('conddepositos','entity', array(
            //    'class'=>'AppBundle:CondDepositos',
            //    'em'=>$this->em
            //))
                
            ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Depositos'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'appbundle_depositos';
    }
}
