<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class ExoneradosType extends AbstractType
{
    
    private $em; 
    public function __construct(\Doctrine\ORM\EntityManager $em) {
        $this->em = $em;
    }
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('resolucion')
            ->add('porcentaje', 'integer')
            //->add('fechainclucion')
            ->add('lapso', 'entity', array(
                'class'=>'AppBundle:Lapso',
                'query_builder'=>function(\Doctrine\ORM\EntityRepository $er) {
                        $q = $er->createQueryBuilder('l')                               
                                ->where('l.activo = :activo ')
                                ->setParameter('activo', 1);
                        return $q;
                    },
                'em'=>$this->em,
                'empty_value'=>'.:Seleccione:.',
            ))
            ///->add('sede')
            ->add('tipo', 'entity', array(
                'empty_value'=>'.:Seleccione:.',
                'class'=>'AppBundle:TipoExoneracion',
                'em'=> $this->em
                
            ))
            //->add('especialidadEstudiante')
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Exonerados'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'appbundle_exonerados';
    }
}
