<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class MatriculaType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */

    private $em;
    
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nota')
            ->add('condicion', 'entity', array(
                'class'=>'AppBundle:CondCurso',
                'query_builder'=>function(\Doctrine\ORM\EntityRepository $er) {
                        $q = $er->createQueryBuilder('c')                               
                            ->where('c.codigo In (:codigo,:codigo2)')
                            ->setParameter('codigo', 'APR')
                            ->setParameter('codigo2', 'APLZ');
                        return $q;
                    },
                'em'=>$this->em,
                'empty_value'=>'.:Seleccione:.',

                'em'=>$this->em,
                'attr'=>array('class'=>'form-control')
            ))    
            ->add('status', 'choice', array('choices'=>array('Acta de Modificacion'=>'Acta de Modificacion')))

        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Matricula'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'appbundle_matricula';
    }
}
