<?php
namespace AppBundle\Controller;


use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Entity\Asesoria;
/**
 * Description of AsesoriaController
 *
 * @author jose
 */
class AsesoriaController extends Controller {
    //put your code here
    
    /**
     * @Route("/app/admin/consult/estud/asesoria", name="app_admin_consul_estud_asesoria")
     */
    public function indexAction()
    {
        $form = $this->formSearchEstudiante();
        return $this->render('AppBundle:Asesoria:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }    
    
    private function formSearchEstudiante()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_result_estud_asesoria'))
                ->setMethod('GET')
                ->add('cedula', 'text', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm()
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/result/estud/asesoria", name="app_admin_result_estud_asesoria", requirements={"_method":"GET"})
     */
    public function searchEstudiantesAction(Request $request)
    {
        $form = $this->formSearchEstudiante();
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $estudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
            
            $ids = $this->getUser()->getSede()->getCodigo();
            $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);            
            $lapsos = $em->getRepository('AppBundle:Lapso')->findBy(array('sede'=>$sede, 'activo'=>1));
            if(!$estudiante){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_admin_result_estud_asesoria'));
            }
            
            return $this->render('AppBundle:Asesoria:result.html.twig', array(
                'datos'=>$estudiante,
                'lapsos'=>$lapsos
            ));
        }
        
        return $this->render('AppBundle:Asesoria:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/asesoria/", name="app_admin_estudiante_asesoria")
     */
    public function asesoriaEstudianteAction(Request $request)
    {
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $lapso = $request->get('lapsoc');
        $especialidad = $request->get('especialidad');
        
        
        $lapsoac = $em->getRepository('AppBundle:Lapso')->find($lapso);
        $espeestud = $em->getRepository('AppBundle:EspeEstud')->find($especialidad);
	$subsede = $espeestud->getSubsede();

        
        $programa = $espeestud->getPrograma();
        $configPrograma = $em->getRepository('AppBundle:ConfigSistema')->findOneBy(array('programa'=>$programa->getId()));                
        $procesos = $em->getRepository('AppBundle:Procesos')->findProcesoActivoFech($lapsoac->getId(), 'PA');
        $especialidadOb =  $em->getRepository('AppBundle:Especialidad')->find($especialidad);
                
        
        /*if(!$procesos){
            $this->get('session')->getFlashBag()->add('msg-error', 'Proceso cerrado para la fecha actual');
            return $this->redirect($request->headers->get('referer'));
        }*/
        
        
        
        $planestudios=$em->getRepository('AppBundle:PlanEstudio')->consultMaterias($programa, $espeestud->getEspecialidad(), $subsede);
        $cursosAprobados=$em->getRepository('AppBundle:Matricula')->findMatriculaEstudAprob($espeestud);
                        
        $cursosOfertados = $em->getRepository('AppBundle:OfertAcade')->findCursoOfertadoNew($espeestud->getEspecialidad()->getId(), $lapsoac->getId(), 0, $especialidad, $subsede);
        $cursosInscritos = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($especialidad, $lapsoac->getId());
        
                
        //$this->get('session')->set('config_act', array('configPrograma'=>$configPrograma,'cursosInscritos'=>$cursosInscritos));
        
        //var_dump($lapsoac);
        //var_dump($espeestud->getEstudiante()->getCedula());
        
       /// var_dump($subsede);
        //var_dump($especialidad);
        //var_dump($programa);
        
        //var_dump($planestudios);
        //die();
        
        $plan = array();
        foreach ($planestudios as $p ){
            $plan[] = array(
                    'idc'      =>$p->getCurso()->getId(),
                    'codc'     =>$p->getCurso()->getCodigo(),
                    'nombrec'  => $p->getCurso()->getNombre(),
                    'semestre'  =>$p->getSemestre(),
                    'uc'  =>$p->getCurso()->getUC(),
                    'check' => false
                
                );
        }
        $oferta = array();
        foreach ($cursosOfertados as $p ){
            $oferta[] = array(
                    'idc'      =>$p->getId(),
                    'codc'     =>$p->getCodigo(),
                    'nombrec'  => $p->getNombre()
                );
        }
        
        //$serializer = \JMS\Serializer\SerializerBuilder::create()->build();
        //$jsonContent = $serializer->serialize($plan, 'json');
        
        return $this->render('AppBundle:Asesoria:asesoria.html.twig', array(
            'cursosofertados'=>$oferta,
            'cursosAprobados'=>$cursosAprobados,
            'cursosInscritos'=>$cursosInscritos,
            //'planesestudios'=> $jsonContent,
            'planesestudios'=> $plan,
            'config'=>$configPrograma,            
            'especialidad'=>$especialidad,
            'lapsoc'=>$lapso,
            'espe_estud'=>$espeestud
        ));    
    }
    
    /**
     * @Route("/app/admin/estudiantes/process/asesoria/{lapso}", name="app_admin_estudiante_process_asesoria")
     */
    public function processAsesoriaEstudianteAction($lapso, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $data = json_decode($request->getContent(), true);
        $estudiante = $data['estudiante'];
        $cursos = $data['cursos'];
        $lapsoObj = $em->getRepository('AppBundle:Lapso')->find($lapso);
        $espeestud = $em->getRepository('AppBundle:EspeEstud')->find($estudiante);
        foreach ($cursos as $e ){
            $curso = $em->getRepository('AppBundle:Cursos')->find($e['idc']);
            $curso_isset = $em->getRepository('AppBundle:Asesoria')->findOneBy(array('lapso'=>$lapsoObj, 'curso'=>$curso, 'estudiante'=>$espeestud));
            if(!$curso_isset){
                $entity = new Asesoria();
                $entity->setEstudiante($espeestud);
                $entity->setCurso($curso);
                $entity->setLapso($lapsoObj);
                $em->persist($entity);
            }
        }
        $em->flush();
        $data = array(
            'mensaje' => 'Asesoria Guardada'
        );
        
        return new \Symfony\Component\HttpFoundation\JsonResponse(json_encode($data), 200);
        
    }
    
    /**
     * @Route("/app/admin/estudiantes/delete/asesoria/{estudianteid}/{cursoid}/{lapsoid}", name="app_admin_estudiante_delete_asesoria")
     */
    public function deleteAsesoriaEstudianteAction($estudiante, $curso,$lapso) {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $matricula = $em->getRepository('AppBundle:Asesoria')->findOneBy(array('estudiante'=>$estudiante, 'curso'=>$curso, 'lapso'=>$lapso));
        $em->remove($matricula);
        $em->flush();
        $this->get('session')->getFlashBag()->add('msg-success', 'Curso eliminado con exito!!');
        
        $data['resp'] = true;
        $response[] = $data;
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        return $respuesta;
    }
    
    
    /**
     * @Route("/app/admin/estudiantes/planilla/asesoria/{id}", name="app_admin_estudiantes_planilla_asesoria")
     */
    public function reportPlanillaAsesoriaAction(Request $request, $id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($this->get('session')->get('lapsoActual')->getId());
        $entities = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($espe_estud, $lapso);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(25,75,10,15,10,55));
        //srand(microtime()*1000000);        
        $headerPage = array('Nombre y Apellido'=>$espe_estud->getEstudiante(), 
                        'Cédula'=>$espe_estud->getEstudiante()->getCedula(),
                        'Especialidad'=>$espe_estud->getEspecialidad()->getNombre(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Planilla de Inscripción - '.$lapso->getCodigo());
        $pdf->aligns = array('C', 'L', 'C', 'C', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Código', 'Nombre del Curso', 'UC', 'Sección', 'Grupo', 'Horario');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        
        foreach ($entities as $value){
            $ucs+=$value->getOferta()->getCurso()->getUc();
            $pdf->RowBorders(array($value->getOferta()->getCurso()->getCodigo(),
                                   $value->getOferta()->getCurso()->getNombre(),
                                   $value->getOferta()->getCurso()->getUc(),
                                   $value->getOferta()->getSeccion(),
                                   $value->getOferta()->getGrupo(),
                                   $value->getOferta()->getHorario()
                            ), 0);
        }
         $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(100, 6,'Total UC: ','T',0,'R');
        $pdf->Cell(10, 6,$ucs,'T',0,'C');
        $pdf->Cell(80, 6,'','T',1,'L');
        $pdf->SetFont('helvetica','B',9);
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        $pdf->Cell(64,10,  utf8_decode('Jefe de la Sección de Control de Estudios'),'T',0,'C');
        $pdf->Cell(63,10,'',0,1,'C');
        
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Planilla de Inscricipcion.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }
}
