<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Utils\phpjru\PJRU;
use AppBundle\Utils\phpjru\JdbcConnection;
use AppBundle\Utils\ReporteLayout;

use Doctrine\ORM\EntityRepository;

use AppBundle\Entity\OfertAcade;
use AppBundle\Form\OfertAcadeType;

/**
 * Description of ReportesController
 *
 * @author jose
 */
class ReportesController extends Controller {
    //put your code here
    
    /**
     * @Route("/app/admin/reports/listado/clases/{programa}/{especialidad}/{lapso}/{sede}/{subsede}/{cohorte}", name="app_admin_listado_clases")
     */
    public function listadoClasesAction($programa = NULL, $especialidad = NULL, $lapso = NULL, $sede = NULL, $subsede = NULL, $cohorte = NULL){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formConsultOferta($em, $programa);
        
        if($programa==NULL && $especialidad==NULL && $lapso==NULL && $sede==NULL&&$subsede==NULL && $cohorte==NULL){
            $oferta = NULL;
        }else{            
            $oferta = $em->getRepository('AppBundle:OfertAcade')->findAllOfertaAcademica($programa, $especialidad, $lapso, $sede, $subsede, $cohorte);
        }
        
        return $this->render('AppBundle:Reportes:listado_clases/index.html.twig', array(
            'form'=>$form->createView(),
            'oferta'=>$oferta,
            'programa'=>$programa,
            'especialidad'=>$especialidad,
            'lapso'=>$lapso,
            'subsede'=>$subsede,
            'cohorte'=>$cohorte,
        ));
    }
    
    private function formConsultOferta(\Doctrine\ORM\EntityManager $em, $programa)
    {
        $form = $this->createFormBuilder()
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:50%;'),                    
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Lapso .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;'),
                ))
                ->add('cohorte', 'entity', array(
                    'class'=>'AppBundle:Cohorte',
                    'em'=>$em,                    
                    'empty_value'=>'Cohorte .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('c')
                                ->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->add('subsede', 'entity', array(
                    'class'=>'AppBundle:SubSede',
                    'em'=>$em,                    
                    'empty_value'=>'Extension .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('s');
                                //->orderBy('c.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))
                ->getForm();
        return $form;
    }
    
    /**
     * @Route("/app/admin/reportes/listado/clases/{id}", name="app_admin_reporte_listado_clases")
     */
    public function reportListadoClasesAction($id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $oferta = $em->getRepository('AppBundle:OfertAcade')->find($id);
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesByOferta($oferta);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(30,70,70,22));
        //srand(microtime()*1000000);
        $pdf->setProfesor($oferta->getProfesor());
        $headerPage = array('Programa'=>$oferta->getPrograma(), 'Especialidad'=>$oferta->getEspecialidad(),
            'Curso'=>$oferta->getCurso(), 'Sección'=>$oferta->getSeccion(), 'Lapso'=>$oferta->getLapso());
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Nómina de Alumnos');
        
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Cédula', 'Nombre', 'Apellidos', 'Nota Final' );
        $pdf->RowTitles($titles);
        
       
        foreach ($entities as $value){
            $pdf->RowBorders(array($value->getEstudiante()->getEstudiante()->getCedula(),
                                   $value->getEstudiante()->getEstudiante()->getPrimerNombre().' '.$value->getEstudiante()->getEstudiante()->getSegundoNombre(),
                                   $value->getEstudiante()->getEstudiante()->getPrimerApellido().' '.$value->getEstudiante()->getEstudiante()->getSegundoApellido(), ' '), 1);
      


        }  

        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Listado de clases.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }
    /**
     * @Route("/app/admin/reportes/test", name="app_admin_reporte_test")
     */
    public function reporteTestAction(){
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(30,80,80));
        srand(microtime()*1000000);
        
        $headerPage = array('Programa'=>'Maestria', 'Especialidad'=>'Maestría en Educación Mención EDUCACION INICIAL',
            'Curso'=>'INIO01 - PROBLEMATICA DE LA EDUC. INICIAL EN VZLA.', 'Sección'=>'EI1141', 'Lapso'=>'2016-1');
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Listado de clases');
        
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Cédula', 'Nombre', 'Apellidos' );
        $pdf->RowTitles($titles);
        
        
        for($i=0;$i<20;$i++){
            $pdf->RowBorders(array($this->GenerateSentence(),$this->GenerateSentence(),
                $this->GenerateSentence(), $this->GenerateSentence(),$this->GenerateSentence()), 0);
        }
        
        $pdf->Output('','test.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }
    
    public function dispositionReporte($filename)
    {
        return new Response($filename, 200, array(
            'Content-Type' => 'application/pdf'));       
    }
    
    
    public function GenerateWord()
    {
        //Get a random word
        $nb=rand(3,5);
        $w='';
        for($i=1;$i<=$nb;$i++)
            $w.=chr(rand(ord('a'),ord('z')));
        return $w;
    }

    public function GenerateSentence()
    {
        //Get a random sentence
        $nb=rand(1,10);
        $s='';
        for($i=1;$i<=$nb;$i++)
            $s.=$this->GenerateWord().' ';
        return substr($s,0,-1);
    }
    
    /**
     * @Route("/app/admin/reports/form/record/academico", name="app_admin_reports_form_record_academico")
     */
    public function recordAcademicoAction($programa = NULL, $especialidad = NULL, $lapso = NULL, $sede = NULL, $subsede = NULL, $cohorte = NULL){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formConsulEstudianteRecord($em);
        
        
        
        return $this->render('AppBundle:Reportes:record_academico/index.html.twig', array(
            'form'=>$form->createView(),
        ));
    }
    
    private function formConsulEstudianteRecord(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_record_academico'))
                ->setMethod('GET')
                ->setAttributes(array('target'=>'_blank'))
                ->add('cedula', 'text', array(
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'mapped'=>false,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');                        
                                $q->where('p.id IS NULL');
                                
                        return $q;
                    },
                    
                    'attr'=>array('class'=>'form-control', 'style'=>'width:85%;'),                    
                ))
                ->getForm();
        return $form;
    }
    
    
    /**
     * @Route("/app/admin/get/especialidades/by/estudiante", name="app_admin_get_especialidades_by_estudiante")
     */
    public function getEspecialidadesAction(Request $request){
        $cedula = $request->get('cedula');
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $especialidades = $em->getRepository('AppBundle:EspeEstud')->getEspecialidadesByEstudiante($cedula);
        
        foreach($especialidades as $value)
            {
                $dato['id'] = $value->getId();
                $dato['text'] = $value->getEspecialidad()->getNombre();
                $response[] = $dato;
            }       
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        
        return $respuesta;
    }
    
    /**
     * @Route("/app/admin/reportes/record/academico", name="app_admin_reporte_record_academico")
     */
    public function reportRecordAcademicoAction(Request $request){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $id =  $form['especialidad'];
        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $entities = $em->getRepository('AppBundle:EspeEstud')->findHistMatri($espe_estud);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(15,25,85,10,10,20,25));
        //srand(microtime()*1000000);        
        $headerPage = array('Nombre y Apellido'=>$espe_estud->getEstudiante(), 
                        'Cédula'=>$espe_estud->getEstudiante()->getCedula(),
                        'Especialidad'=>$espe_estud->getEspecialidad()->getNombre(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Record Académico');
        $pdf->aligns = array('C','C', 'L', 'C', 'C', 'C', 'L');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Lapso', 'Código', 'Nombre del Curso', 'UC', 'Cal', 'UC*Cal', 'Condición');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $puntos = 0;
        $indiceac = 0;
        foreach ($entities as $value){
                 
            if($value->getCurso()->getPlanestudio()[0]->getComponentes()->getDescripcion()=='TRABAJO DE GRADO'){
                $nota = '';
                $uc = 0;
                $ucxnota = '';
            }else{
                 $nota = $value->getNota();
                 $uc = $value->getCurso()->getUc();
                 $ucxnota = $nota * $uc;
                 $puntos += $ucxnota;
                 $indiceac += $uc;
             }
            $pdf->RowBorders(array($value->getLapso()->getCodigo(),
                                   $value->getCurso()->getCodigo(),
                                   $value->getCurso()->getNombre(),
                                   $uc,
                                   $nota,
                                   $ucxnota,
                                   $value->getCondicion()->getNombre(),
                            ), 0);
        }  
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(63,10,'Puntos: '.  number_format($puntos, 2, ',','.'),'T',0,'C');
        $pdf->Cell(64,10,'UC indice: '.$indiceac,'T',0,'C');
        $pdf->Cell(63,10,'IND*ACAD: '.number_format($puntos/$indiceac,2,',','.'),'T',1,'C');
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $text1 = "UC= Unid. de Credito, IA= Indice Acad.(PTOS/UC), PTOS= Puntos(Suma de UC x C), C=Calificacion, CM= Cond. de Asig.; 3= Equiivalencia, 4= DOC. NoTrans.calf.,
6= Nota en Observa.,7= Prueba Extraor., 8= Sin Nota., 9= Inasistente.CM= 3,4,6,8 y 9 no afectan el Indice";
        $pdf->MultiCell(190, 3, $text1,0,'J');
        $text2 = "INDICE ACADEMICO CALCULADO SEGUN RESOLUCION No.2008.316.2818 EXAMINADA DEL CONSEJO UNIVERSIATRIO FECHA: 23 JULIO DE2008";
        $pdf->MultiCell(190, 3, $text2,0,'J');
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        $pdf->Cell(64,10,  utf8_decode('Jefe de la Sección de Control de Estudios'),'T',0,'C');
        $pdf->Cell(63,10,'',0,1,'C');
        
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Listado de clases.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }
    
    /**
     * @Route("/app/admin/reports/form/planilla/inscripcion", name="app_admin_form_planilla_inscripcion")
     */
    public function planillaInscripcionAction(){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formConsulEstudiantePlanillaInscripcion($em);
        
        
        return $this->render('AppBundle:Reportes:planilla_inscripcion/index.html.twig', array(
            'form'=>$form->createView(),
        ));
    }
    private function formConsulEstudiantePlanillaInscripcion(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_planilla_inscripcion'))
                ->setMethod('GET')
                ->setAttributes(array('target'=>'_blank'))
                ->add('cedula', 'text', array(
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,
                    'mapped'=>false,
                    'empty_value'=>'Lapso .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('l');
                        $q->orderBy('l.codigo', 'DESC');
                        return $q;
                    },
                    
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),                    
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'mapped'=>false,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');                        
                                $q->where('p.id IS NULL');
                                
                        return $q;
                    },
                    
                    'attr'=>array('class'=>'form-control', 'style'=>'width:75%;'),                    
                ))
                ->getForm();
        return $form;
    }
    
    /**
     * @Route("/app/admin/reportes/planilla/inscripcion", name="app_admin_reporte_planilla_inscripcion")
     */
    public function reportPlanillaInscripcionAction(Request $request){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $id =  $form['especialidad'];
        $lapsoid = $form['lapso'];
        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $entities = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($espe_estud, $lapso);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();  
        $pdf->setSede($espe_estud->getSede());       
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(20,75,8,15,70));
        //srand(microtime()*1000000);        
        $headerPage = array('Nombre y Apellido'=>$espe_estud->getEstudiante(), 
                        'Cédula'=>$espe_estud->getEstudiante()->getCedula(),
                        'Especialidad'=>$espe_estud->getEspecialidad()->getNombre(),
                        'Sede'=>$espe_estud->getSede()->getNombre(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Planilla de Inscripción - '.$lapso->getCodigo());
        $pdf->aligns = array('C', 'L', 'C', 'C', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Código', 'Nombre del Curso', 'C.A', 'Sección', 'Horario');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        
        foreach ($entities as $value){
            $ucs+=$value->getOferta()->getCurso()->getUc();
            $pdf->RowBorders(array($value->getOferta()->getCurso()->getCodigo(),
                                   $value->getOferta()->getCurso()->getNombre(),
                                   $value->getOferta()->getCurso()->getUc(),
                                   $value->getOferta()->getSeccion(),
                                    $value->getOferta()->getHorario() 
                            ), 0);
        }
       
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(100, 6,utf8_decode('Total Créditos Académicos: '),'T',0,'R');
        $pdf->Cell(10, 6,$ucs,'T',0,'C');
        $pdf->Cell(80, 6,'','T',1,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(5);
        $pdf->Ln(90);
        $pdf->SetFont('helvetica','',8);
 	$pdf->Cell(0,10,  utf8_decode('- Control de Estudios se reserva el derecho de modificar y eliminar la planilla de Inscripción Nacional cuando se detecten aspectos que no proceden.'),'',0,'L');
        $pdf->SetFont('helvetica','',8);
 	$pdf->Ln(3);
	$pdf->Cell(0,10,  utf8_decode('- Para ser válida la inscripción debe consignarse este documento ante Control de Estudios.'),'',0,'L');
        $pdf->SetFont('helvetica','',8);
 	$pdf->Ln(3);
	$pdf->Cell(0,10,  utf8_decode('- Se considera como válida la última planilla de inscripción que emita el sistema.'),'',0,'L');
        $pdf->Ln(10);
        $pdf->SetFont('helvetica','',7);
        $pdf->Cell(64,10,  utf8_decode('ESTUDIANTE'),'',0,'C');
        $pdf->Cell(64,10,  utf8_decode('SELLO'),'',0,'C');
        $pdf->Cell(64,10,  utf8_decode('CONTROL DE ESTUDIOS'),'',0,'C');
        $pdf->Cell(63,10,'',0,1,'C');
        
        
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Planilla de Inscricipcion.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }
    

//**************************************reporte constancia**********************************************
     

    /**
     * @Route("/app/admin/reports/form/planilla/constanciaestudio", name="app_admin_form_planilla_constanciaestudio")
     */
    public function planillaConstanciaestudioAction(){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formConsulEstudiantePlanillaConstanciaestudio($em);
        
        
        return $this->render('AppBundle:Reportes:constancia_estudio/index.html.twig', array(
            'form'=>$form->createView(),
        ));
    }
    private function formConsulEstudiantePlanillaConstanciaestudio(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_planilla_constanciaestudio'))
                ->setMethod('GET')
                ->setAttributes(array('target'=>'_blank'))
                ->add('cedula', 'text', array(
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,
                    'mapped'=>false,
                    'empty_value'=>'Lapso .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('l');
                        $q->orderBy('l.codigo', 'DESC');
                        return $q;
                    },
                    
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),                    
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'mapped'=>false,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');                        
                                $q->where('p.id IS NULL');
                                
                        return $q;
                    },
                    
                    'attr'=>array('class'=>'form-control', 'style'=>'width:75%;'),                    
                ))
                ->getForm();
        return $form;
    }
    

     /**
     * @Route("/app/admin/reportes/planilla/constanciaestudio", name="app_admin_reporte_planilla_constanciaestudio")
     */
    public function reportPlanillaConstanciaAction(Request $request){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $id =  $form['especialidad'];
        $lapsoid = $form['lapso'];
        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $entities = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($espe_estud, $lapso);
       
        $subsedeausar = $espe_estud->getSubsede()->getId();
        $cargo = '12';
        $activo = '1';
        $autoridad = $em->getRepository('AppBundle:Autoridades')->findOneBy(array('subsede'=>$subsedeausar,'cargo'=>$cargo, 'activo'=>$activo));
        //$sede= $em->getRepository('AppBundle:Sede')->findByCodigo($ids);
        

        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();  
        $pdf->setSede($espe_estud->getSede());       
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(20,75,8,15,70));
        //srand(microtime()*1000000);        
        
         
        $pdf->titleReport(''.$espe_estud->getSede());
        
        $pdf->titleReport('Constancia de Estudios ');
         $pdf->Ln(6);
        $ucs = 0;
         foreach ($entities as $value){
            $ucs+=$value->getOferta()->getCurso()->getUc();
           
                  
        }

       // $fecha2 = new \DateTime();
       // $fecha2->format('d-m-Y');
        $pdf->Ln(2);

        //fecha en español*****************************************************
        $dia=date("l"); // dia en lunes martes etc
        
        if ($dia=="Monday") $dia="Lunes";
        if ($dia=="Tuesday") $dia="Martes";
        if ($dia=="Wednesday") $dia="Miércoles";
        if ($dia=="Thursday") $dia="Jueves";
        if ($dia=="Friday") $dia="Viernes";
        if ($dia=="Saturday") $dia="Sabado";
        if ($dia=="Sunday") $dia="Domingo";
        
        $mes=date("F"); //mes en enero febrero etc
        
        if ($mes=="January") $mes="Enero";
        if ($mes=="February") $mes="Febrero";
        if ($mes=="March") $mes="Marzo";
        if ($mes=="April") $mes="Abril";
        if ($mes=="May") $mes="Mayo";
        if ($mes=="June") $mes="Junio";
        if ($mes=="July") $mes="Julio";
        if ($mes=="August") $mes="Agosto";
        if ($mes=="September") $mes="Setiembre";
        if ($mes=="October") $mes="Octubre";
        if ($mes=="November") $mes="Noviembre";
        if ($mes=="December") $mes="Diciembre";
        
        $ano=date("Y"); // año completo 2017 
        $dia2=date("d");// solo dia en numero

        $fecha = date('j-m-Y');
        $nuevafecha = strtotime ( '+3 month' , strtotime ( $fecha ) ) ;
        $nuevafecha = date ( 'j/m/Y' , $nuevafecha );
        //fecha en español*****************************************************
        
        $text3 = "    Quien suscribe, ".$autoridad->getNombre().' '.$autoridad->getApellido() .' titular de la Cédula de identidad  N° '.$autoridad->getCedula() .' hace constar que el (la) ciudadano(a)  '.$espe_estud->getEstudiante()->getPrimerNombre().' '.$espe_estud->getEstudiante()->getSegundoNombre().' '.$espe_estud->getEstudiante()->getPrimerApellido(). ' '.$espe_estud->getEstudiante()->getSegundoApellido().
             " titular de la Cédula de identidad N°".$espe_estud->getEstudiante()->getCedula().
             ' cursa estudios en el '. $espe_estud->getSubsede()->getDescripcion() .' en la Especialidad de '.$espe_estud->getEspecialidad()->getNombre().
                '. Está inscrito(a) en el actual período académico ordinario '.$lapso->getCodigo().
                ' , hasta la fecha tiene '. $ucs  .   ' Unidades Inscritas, que lo ubican en el 1° semestre. Pertenece a la matrícula de ingreso '.$espe_estud->getCohorte().'.'.
        $pdf->SetFont('helvetica','',12);
        $pdf->MultiCell(190, 5,  utf8_decode($text3),0,'J');
  
                      
        $pdf->Ln(10);       
        $text4=   ' Constancia que se expide a solicitud de la parte interesada, a los '.$dia2.' días del mes de '. $mes  .' del año '.$ano .'.'.
                   
        $pdf->SetFont('helvetica','',12);
        $pdf->MultiCell(190, 5,  utf8_decode($text4),0,'J');
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(50);
        $pdf->Cell(63,10,'',0,0,'C');
        
        $pdf->Cell(64,10,  utf8_decode($autoridad->getNombre().' '.$autoridad->getApellido() ),'T',0,'C');
        $pdf->Cell(63,10,'',0,1,'C');
        $pdf->Ln(1);
        $pdf->Cell(0,0,  utf8_decode(' Jefe(a) de la Sección de Control de Estudios '),'',0,'C');
        $pdf->Ln(8);
        
        $pdf->Cell(0,0,  utf8_decode('Sello'),'',0,'C');

        $pdf->Ln(40);
        $pdf->Cell(0,0,  utf8_decode('Vigente desde: '. $lapso->getFechaInicial().' hasta final del '.$lapso->getFechaFinal()),'',0,'');
        $pdf->Ln(4);
        $pdf->Cell(0,0,  utf8_decode('Va sin enmienda'),'',0,'');
        
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Planilla de Inscricipcion.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }

















































    /**
     * @Route("/app/admin/reports/form/totales/inscritos", name="app_admin_reports_form_totales_inscritos")
     */
    public function totalesInscritosFormAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formTotalesInscritos($em);
        
        return $this->render('AppBundle:Reportes:totales_inscritos/index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formTotalesInscritos(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reporte_totales_inscritos'))
                ->setMethod('POST')
                ->setAttributes(array('attr'=>array('target'=>'_blank')))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em, 
                    'mapped'=>false,
                    'query_builder'=>function(EntityRepository $er) {
                        $q = $er->createQueryBuilder('l');
                        $q->orderBy('l.codigo', 'DESC');
                        return $q;
                    },
                ))
                ;
        return $form->getForm();
    }
    
    /**
     * @Route("/app/admin/reportes/totales/inscritos", name="app_admin_reporte_totales_inscritos")
     */
    public function reporteTotalesInscritosAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $programaid =  $form['programa'];
        
        $lapsoid = $form['lapso'];
        $programa = $em->getRepository('AppBundle:Programa')->find($programaid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesInscritos($lapso, $programa);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(170,20));
        //srand(microtime()*1000000);        
        
        $pdf->titleReport(''.$lapso->getSede());
        $pdf->titleReport('Totales de Inscritos- '.$lapso->getCodigo());
        $pdf->aligns = array('L', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Especialidad', 'Cant.');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        
        foreach ($entities as $value){
            $ucs+=count($value->getEspeestud());
            $pdf->RowBorders(array(($value->getNombre()),
                                   count($value->getEspeestud())
                            ), 0);
        }
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(170, 6,'Total: ','T',0,'R');
        $pdf->Cell(20, 6,$ucs,'T',0,'C');
        $pdf->SetFont('helvetica','B',9);
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','totales_inscritos.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
        
    }
    
     /**
     * @Route("/app/admin/form/listado/inscritos/{programa}", name="app_admin_listado_inscritos")
     */
    public function listadoInscritosAction($programa = NULL){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formListadoInscritos($em, $programa);
        
        return $this->render('AppBundle:Reportes:listado_inscritos/index.html.twig', array(
            'form'=>$form->createView(),
            'programa'=>$programa,
            
        ));
    }
    
    private function formListadoInscritos(\Doctrine\ORM\EntityManager $em, $programa)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_reportes_inscritos'))
                ->setMethod('POST')
                ->setAttribute('attr', array('target'=>'_blank'))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:70%;'),                    
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Lapso .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;'),
                ))
                ->getForm();
        return $form;
    }

    /**
     * @Route("/app/admin/reporte/listado/inscritos/", name="app_admin_reportes_inscritos")
     */
    public function reproteListadoInscritosAction(Request $request){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $request->get('form');
        
        $lapsoid = $form['lapso'];
        $programaid = $form['programa'];
        $especialidadid = $form['especialidad'];
        
        $programa = $em->getRepository('AppBundle:Programa')->find($programaid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $especialidad = $em->getRepository('AppBundle:Especialidad')->find($especialidadid);
        
        $entities = $em->getRepository('AppBundle:Matricula')->getEstudiantesInscritosByEspecialidad($lapso, $programa, $especialidad);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(18,50,50,10,20,20,25));
        //srand(microtime()*1000000);        
        $headerPage = array('Programa'=>$programa->getNombre(), 
                        'Especialidad'=>$especialidad->getNombre(),
                        'Lapso'=>$lapso->getCodigo(),
                        'Sede'=>$especialidad->getSede(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Estudiantes Inscritos');
        $pdf->aligns = array('C', 'L', 'L', 'C', 'C', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Cédula', 'Apellidos','Nombres', 'Sexo', 'Fecha nac.', 'Fecha ing', 'Lapso');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        
        foreach ($entities as $value){
            $ucs = count($value->getEspeestud());
            foreach ($value->getEspeestud() as $v){
                $pdf->RowBorders(array(($v->getEstudiante()->getCedula()),
                                      ($v->getEstudiante()->getPrimerApellido().' '.$v->getEstudiante()->getSegundoApellido()),
                                       ($v->getEstudiante()->getPrimerNombre().' '.$v->getEstudiante()->getSegundoNombre()),
                                      (strtoupper($v->getEstudiante()->getSexo())),            
                                  ($v->getEstudiante()->getFechaNacimiento()->format('d-m-Y')),
                                       ($v->getFechaIngreso()->format('d-m-Y')),
                                       $lapso->getCodigo()
                                ), 0);
            }
        }
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(170, 6,'Total: ','T',0,'R');
        $pdf->Cell(20, 6,$ucs,'T',0,'C');
        $pdf->SetFont('helvetica','B',9);
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        
        $pdf->Output('','totales_inscritos.pdf', 1);
        
             return $this->dispositionReporte($pdf->Output());
       
    }
    
    /**
     * @Route("/app/admin/reporte/form/depositos/exonerados", name="app_admin_reporte_form_dep_exon")
     */
    public function reporteDepositosExoneradosAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formDepotisoExonerados($em);
        
        return $this->render('AppBundle:Reportes:depositosexon/index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/generate/reports/dep/exon", name="app_admin_generate_reports_dep_exon")
     */
    public function generateReporteDepExoneradoAction(Request $request){
        $form = $request->get('form');
        
        $lapsoid = $form['lapso'];
        $programaid = $form['programa'];
        $especialidadid = $form['especialidad'];
        $tipo_reporte = $form['tipo_reporte'];
        if($tipo_reporte=='depositos')
        {
            $pdf = $this->generarReporteDepositos($lapsoid, $programaid, $especialidadid);
        }
        if($tipo_reporte=='exonorados')
        {
            $pdf = $this->generarReporteExonerados($lapsoid, $programaid, $especialidadid);
        }
        
        return $this->dispositionReporte($pdf->Output());
    }    
   
    private function generarReporteDepositos($lapsoid, $programaid, $especialidadid)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $especialidad = $em->getRepository('AppBundle:Especialidad')->find($especialidadid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        
        $entities = $em->getRepository('AppBundle:Depositos')->findByDepositosByEspecialidad($especialidad ,$lapso);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
      
        $pdf->SetWidths(array(18,66,66,20,20));
        //srand(microtime()*1000000);        
        $headerPage = array('Programa'=>$especialidad->getPrograma()->getNombre(), 
                        'Especialidad'=>$especialidad->getNombre(),
                        'Lapso'=>$lapso->getCodigo(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Reporte de Depósitos');
        $pdf->aligns = array('C', 'L', 'L', 'C', 'R', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Cédula', 'Apellidos','Nombres', '#Bauche', 'Monto');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $sum = 0;
        foreach ($entities as $v){
                $depositos = "";
                $montos = "";
                foreach ($v->getDepositos() as $d)
                {
                    $depositos .= $d->getNumDeposito()."\n";
                    $montos .= number_format($d->getMonto(), 2,'.',',')."\n";
                    $sum += $d->getMonto();
                }
                $pdf->RowBorders(array(utf8_decode($v->getEstudiante()->getCedula()),
                                       utf8_decode($v->getEstudiante()->getPrimerApellido().' '.$v->getEstudiante()->getSegundoApellido()),
                                       utf8_decode($v->getEstudiante()->getPrimerNombre().' '.$v->getEstudiante()->getSegundoNombre()),
                                       utf8_decode($depositos),
                                       utf8_decode($montos),
                                ), 0);
        }
        $pdf->SetFont('helvetica','B',8);
        $pdf->Cell(170,6,  'Total:','T', 0, 'R');
        $pdf->Cell(20,6,  number_format($sum, 2, '.', ','),'T', 1, 'R');
        
        $pdf->Output('','reporte_depositos.pdf', 1);
        return $pdf;
        
    }
    
    private function generarReporteExonerados($lapsoid, $programaid, $especialidadid)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $especialidad = $em->getRepository('AppBundle:Especialidad')->find($especialidadid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        
        $entities = $em->getRepository('AppBundle:Exonerados')->findByExoneracionByEspecialidad($especialidad ,$lapso);
        
        $exoneradosArr;
        $configPrograma = $em->getRepository('AppBundle:ConfigSistema')->findOneBy(array('programa'=>$programaid));
        foreach ($entities as $e)
        {
            //echo count($e->getMatricula());
            //die();
            $montoIns = $em->getRepository('AppBundle:Matricula')->getMontoInscritoEstudiante($e->getMatricula(), $em, $configPrograma);
            $porcentaje = $e->getExonerados()[0]->getPorcentaje();
            
            $exoneradosArr[] = array(
                'cedula'=>$e->getEstudiante()->getCedula(),
                'apellidos'=>$e->getEstudiante()->getPrimerApellido().' '.$e->getEstudiante()->getSegundoApellido(),
                'nombres'=>$e->getEstudiante()->getPrimerNombre().' '.$e->getEstudiante()->getSegundoNombre(),
                'tipo'=>$e->getExonerados()[0]->getTipo()->getDescripcion(),
                'resolucion'=>$e->getExonerados()[0]->getResolucion(),
                'porcentaje'=> number_format($porcentaje, 2, ',', '.'),
                'montoInsc'=> number_format($montoIns, 2, ',', '.'),
                'monto'=>  number_format(($montoIns*$porcentaje)/100, 2, '.','')
            );
        }
        
        
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
      
        $pdf->SetWidths(array(18,45,45,35,22,25));
        //srand(microtime()*1000000);        
        $headerPage = array('Programa'=>$especialidad->getPrograma()->getNombre(), 
                        'Especialidad'=>$especialidad->getNombre(),
                        'Lapso'=>$lapso->getCodigo(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Reporte de Exoneración');
        $pdf->aligns = array('C', 'L', 'L', 'L', 'C', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Cédula', 'Apellidos','Nombres', 'Resolución', 'Porcentaje', 'Monto');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $sum = 0;
        foreach ($exoneradosArr as $v){
                $sum += $v['monto'];
                
                $pdf->RowBorders(array(utf8_decode($v['cedula']),
                                       utf8_decode($v['apellidos']),
                                       utf8_decode($v['nombres']),
                                       utf8_decode($v['resolucion']),
                                       utf8_decode($v['porcentaje']),
                                       utf8_decode($v['monto']),
                                ), 0);
        }
        $pdf->SetFont('helvetica','B',8);
        $pdf->Cell(165 ,6,  'Total:','T', 0, 'R');
        $pdf->Cell(25,6,  number_format($sum, 2, '.', ''),'T', 1, 'C');
        
        $pdf->Output('','reporte_depositos.pdf', 1);
        return $pdf;
        
    }
    
    private function formDepotisoExonerados(\Doctrine\ORM\EntityManager $em, $programa = null)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_generate_reports_dep_exon'))
                ->setMethod('POST')
                ->setAttribute('attr', array('target'=>'_blank'))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:60%;'),
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Lapso .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;'),
                ))
                ->add('tipo_reporte', 'choice', array(
                    'choices'=>array('depositos'=>'Depósitos', 'exonorados'=>'Exonerados'),
                    'attr'=>array('class'=>'form-control', 'style'=>'width:10%;'),
                ))

                ->getForm();
        return $form;
    }
    
    /**
     * @Route("/app/admin/reporte/form/sintranscripcion/", name="app_admin_report_form_sintranscripcion")
     */
    public function generarFormSinTranscribirAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formProfesoresSinTranscripcion($em);
        
        return $this->render('AppBundle:Reportes:profesores_sin_transcribir/index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/reporte/sintranscripcion/", name="app_admin_report_sintranscripcion")
     */
    public function generarReportSinTranscribirAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $form = $request->get('form');
        $lapsoid = $form['lapso'];
        $programaid = $form['programa'];
        $especialidadid = $form['especialidad']; 
        
        $especialidad = $em->getRepository('AppBundle:Especialidad')->find($especialidadid);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($lapsoid);
        $ids = $this->getUser()->getSede()->getCodigo();
        $sede= $em->getRepository('AppBundle:Sede')->findByCodigo($ids);
        
        $entities = $em->getRepository('AppBundle:OfertAcade')->findOfertaSinTranscribirA($especialidad, $lapso, $sede);
        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-success', 'No se encuentran profesores sin transcribir!');
            return $this->redirect($this->generateUrl('app_admin_report_form_sintranscripcion'));
        }
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
      
        $pdf->SetWidths(array(20,85, 85));
        //srand(microtime()*1000000);        
        $headerPage = array('Programa'=>$especialidad->getPrograma()->getNombre(), 
                        'Especialidad'=>$especialidad->getNombre(),
                        'Lapso'=>$lapso->getCodigo(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Reporte profesores sin transcribir');
        $pdf->aligns = array('C', 'L', 'L');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Cédula', 'Apellidos','Nombres');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $sum = 0;
        foreach ($entities as $v){
            $pdf->RowBorders(array(utf8_decode($v->getCedula()),
                                   utf8_decode($v->getPrimerApellido().' '.$v->getSegundoApellido()),
                                   utf8_decode($v->getPrimerNombre().' '.$v->getSegundoNombre())
                            ), 0);
        }
        $pdf->SetFont('helvetica','B',8);
        $pdf->Cell(165 ,6,  'Total:','T', 0, 'R');
        $pdf->Cell(25,6,  number_format($sum, 2, '.', ''),'T', 1, 'C');
        
        $pdf->Output('','reporte_profesores_sin_transcribir.pdf', 1);
        return $pdf;
        
        
        
    }
    
    private function formProfesoresSinTranscripcion(\Doctrine\ORM\EntityManager $em, $programa = null)
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_report_sintranscripcion'))
                ->setMethod('POST')
                ->setAttribute('attr', array('target'=>'_blank'))
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,       
                    'empty_value'=>'Programa .:seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'empty_value'=>'Especialidad .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er) use ($programa){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p');
                        if($programa == NULL)
                                $q->where('p.id IS NULL');
                        else
                                $q->where('p.id = '.$programa);
                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:70%;'),
                ))
                ->add('lapso', 'entity', array(
                    'class'=>'AppBundle:Lapso',
                    'em'=>$em,                    
                    'empty_value'=>'Lapso .:seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('l')
                                ->orderBy('l.codigo', 'DESC');                                
                        return $q;
                    },
                    'attr'=>array('class'=>'form-control', 'style'=>'width:15%;'),
                ))

                ->getForm();
        return $form;
    }
}
