<?php
namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\TipoSubSede;
use AppBundle\Form\TipoSubSedeType;

/**
 * Description of TipoSubSedeController
 *
 * @author jose
 */
class TipoSubSedeController extends Controller {
    


    /**
     *  @Route("/app/admin/tiposubsede", name="app_admin_tiposubsede_index")
     */
    public function indexAction()
    {  
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $query = "SELECT l FROM AppBundle:TipoSubSede l "
                . "ORDER BY l.id DESC ";
        $entities = $em->createQuery($query);        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:TipoSubSede:index.html.twig', array(
            'pagination'=>$pagination
        ));
    }
    
    /**
     *  @Route("/app/admin/search/tiposubsede", name="app_admin_tiposubsede_search_index")
     */
    public function searchAction(Request $request)
    {  
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $text = $request->get('text');
        $query = "SELECT l FROM AppBundle:TipoSubSede l "
                . "WHERE "
                . "l.id LIKE :text "
                . "ORDER BY l.id DESC ";
        $entities = $em->createQuery($query);        
        $entities->setParameter('text', '%'.$text.'%');
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:TipoSubSede:index.html.twig', array(
            'pagination'=>$pagination
        ));
    }
    
    /**
     * @Route("/app/admin/edit/tiposubsede/{id}", name="app_admin_tiposubsede_edit")
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:TipoSubSede')->find($id);        
        $form = $this->editForm($entity);
        
        return $this->render('AppBundle:TipoSubSede:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/update/tiposubsede/{id}", name="app_admin_tiposubsede_update", requirements={"_method":"PUT"})
     */
    public function updateAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:TipoSubSede')->find($id);        
        $form = $this->editForm($entity);
        
        $form->handleRequest($request);
        
        if($form->isValid())
        {
            $em->persist($entity);
            $em->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
            return $this->redirect($this->generateUrl('app_admin_tiposubsede_index'));
        }
        
        return $this->render('AppBundle:TipoSubSede:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function editForm(TipoSubSede $entity)
    {
        $form = $this->createForm(new TipoSubSedeType(), $entity, array(
            'action'=>$this->generateUrl('app_admin_tiposubsede_update', array('id'=>$entity->getId())),
            'method'=>'PUT'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/new/tiposubsede", name="app_admin_tiposubsede_new")
     */
    public function newAction()
    {
        $entity = new TipoSubSede();
        $form = $this->newForm($entity);
        
        return $this->render('AppBundle:TipoSubSede:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/create/tiposubsede", name="app_admin_tiposubsede_create", requirements={"_method":"POST"})
     */
    public function createAction(Request $request)
    {
        $entity = new TipoSubSede();
        $form = $this->newForm($entity);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $em->persist($entity);
            $em->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro creado con exito!');
            return $this->redirect($this->generateUrl('app_admin_tiposubsede_index'));
        }
        
        return $this->render('AppBundle:TipoSubSede:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function newForm(TipoSubSede $entity)
    {
        $form = $this->createForm(new TipoSubSedeType(), $entity, array(
            'action'=>$this->generateUrl('app_admin_tiposubsede_create'),
            'method'=>'POST'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
}