<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ambiente")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\AmbienteRepository")
 */
class Ambiente
{
     /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @var string
     *
     * @ORM\Column(name="cod_ambiente", type="string", length=255, nullable=false)
     */
    private $codAmbiente;

    /**
     * @var string
     *
     * @ORM\Column(name="descripcion", type="string", length=255, nullable=false)
     */
    private $descripcion;



    /**
     * @var string
     *
     * @ORM\Column(name="vigente", type="string", length=20, nullable=false)
     */
    private $vigente;


        /**
     * @ORM\OneToMany(targetEntity="OfertAcade", mappedBy="modalidad")
     */    
    protected $ofertacade;
    
    

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->ofertacade = new \Doctrine\Common\Collections\ArrayCollection();
    }

    
    
    
    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codAmbiente
     *
     * @param string $codAmbiente
     *
     * @return Ambiente
     */
    public function setCodAmbiente($codAmbiente)
    {
        $this->codAmbiente = $codAmbiente;

        return $this;
    }

    /**
     * Get codAmbiente
     *
     * @return string
     */
    public function getCodAmbiente()
    {
        return $this->codAmbiente;
    }

    /**
     * Set descripcion
     *
     * @param string $descripcion
     *
     * @return Ambiente
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;

        return $this;
    }

    /**
     * Get descripcion
     *
     * @return string
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    

    /**
     * Set vigente
     *
     * @param string $vigente
     *
     * @return Ambiente
     */
    public function setVigente($vigente)
    {
        $this->vigente = $vigente;

        return $this;
    }

    /**
     * Get vigente
     *
     * @return string
     */
    public function getVigente()
    {
        return $this->vigente;
    }
    
     /**
     * Add ofertacade
     *
     * @param \AppBundle\Entity\OfertAcade $ofertacade
     *
     * @return Modalidad
     */
    public function addOfertacade(\AppBundle\Entity\OfertAcade $ofertacade)
    {
        $this->ofertacade[] = $ofertacade;

        return $this;
    }

    /**
     * Remove ofertacade
     *
     * @param \AppBundle\Entity\OfertAcade $ofertacade
     */
    public function removeOfertacade(\AppBundle\Entity\OfertAcade $ofertacade)
    {
        $this->ofertacade->removeElement($ofertacade);
    }

    /**
     * Get ofertacade
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOfertacade()
    {
        return $this->ofertacade;
    }
    
        public function __toString()
    {
        return $this->descripcion;
    }
    
    
    
    
}
