<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="autoridades")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\AutoridadesRepository")
 */
class Autoridades {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=5)
     */
    protected $titulo;
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $nombre;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $apellido;

    /**
     * @ORM\Column(type="integer", length=15)
     */
    protected $cedula;
    
    
    /**
     * @ORM\Column(type="string", length=60)
     */
    protected $cargo;    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="autoridades")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;

    /**
     * @ORM\ManyToOne(targetEntity="SubSede", inversedBy="autoridades")
     * @ORM\JoinColumn(name="subsede_id", referencedColumnName="id")
     */
    protected $subsede;
   
    /**
     * @ORM\Column(type="string", length=15)
     */
    protected $activo;
    

   

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set titulo
     *
     * @param string $titulo
     *
     * @return Autoridades
     */
    public function setTitulo($titulo)
    {
        $this->titulo = $titulo;

        return $this;
    }

    /**
     * Get titulo
     *
     * @return string
     */
    public function getTitulo()
    {
        return $this->titulo;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     *
     * @return Autoridades
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;

        return $this;
    }

    /**
     * Get nombre
     *
     * @return string
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set apellido
     *
     * @param string $apellido
     *
     * @return Autoridades
     */
    public function setApellido($apellido)
    {
        $this->apellido = $apellido;

        return $this;
    }

    /**
     * Get apellido
     *
     * @return string
     */
    public function getApellido()
    {
        return $this->apellido;
    }

    /**
     * Set cargo
     *
     * @param string $cargo
     *
     * @return Autoridades
     */
    public function setCargo($cargo)
    {
        $this->cargo = $cargo;

        return $this;
    }

    /**
     * Get cargo
     *
     * @return string
     */
    public function getCargo()
    {
        return $this->cargo;
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     *
     * @return Autoridades
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;

        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Set subsede
     *
     * @param \AppBundle\Entity\SubSede $subsede
     *
     * @return Autoridades
     */
    public function setSubsede(\AppBundle\Entity\SubSede $subsede = null)
    {
        $this->subsede = $subsede;

        return $this;
    }

    /**
     * Get subsede
     *
     * @return \AppBundle\Entity\SubSede
     */
    public function getSubsede()
    {
        return $this->subsede;
    }
      public function __toString()
    {
        return $this->descripcion;
    }


    /**
     * Set cedula
     *
     * @param integer $cedula
     *
     * @return Autoridades
     */
    public function setCedula($cedula)
    {
        $this->cedula = $cedula;

        return $this;
    }

    /**
     * Get cedula
     *
     * @return integer
     */
    public function getCedula()
    {
        return $this->cedula;
    }

    /**
     * Set activo
     *
     * @param string $activo
     *
     * @return Autoridades
     */
    public function setActivo($activo)
    {
        $this->activo = $activo;

        return $this;
    }

    /**
     * Get activo
     *
     * @return string
     */
    public function getActivo()
    {
        return $this->activo;
    }

}
