<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="espe_estud")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\EspeEstudRepository")
 * @ORM\HasLifecycleCallbacks()

 */
class EspeEstud {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="Estudiante", inversedBy="espeestud")
     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")
     */
    protected $estudiante;
    
    /**
     * @ORM\ManyToOne(targetEntity="Programa", inversedBy="espeestud")
     * @ORM\JoinColumn(name="programa_id", referencedColumnName="id")
     */
    protected $programa;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="espeestud")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
    /**
     * @ORM\ManyToOne(targetEntity="Especialidad", inversedBy="espeestud")
     * @ORM\JoinColumn(name="especialidad_id", referencedColumnName="id")
     */
    protected $especialidad;
    
    /**
     * @ORM\ManyToOne(targetEntity="Cohorte", inversedBy="espeestud")
     * @ORM\JoinColumn(name="cohorte_id", referencedColumnName="id")
     */
    protected $cohorte;
    
    /**
     * @ORM\ManyToOne(targetEntity="TipoIngreso", inversedBy="espeestud")
     * @ORM\JoinColumn(name="ingreso_id", referencedColumnName="id")
     */
    protected $ingreso;
    
    /**
     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="espeestud")
     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")
     */
    protected $cod_lapso;
    
    /**
     * @ORM\ManyToOne(targetEntity="CodSitua", inversedBy="espeestud")
     * @ORM\JoinColumn(name="situa_id", referencedColumnName="id")
     */
    protected $cod_situa;
    
    /**
     * @ORM\Column(type="datetime", nullable=false)
     */
    protected $fecha_ingreso;
    
    /**
     * @ORM\Column(type="boolean")
     */
    protected $activo;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    protected $observacion;
    
    /**
     * @ORM\OneToMany(targetEntity="Matricula", mappedBy="estudiante")
     */
    protected $matricula;
    
    /**
     * @ORM\OneToMany(targetEntity="Depositos", mappedBy="estudiante")
     */
    protected $depositos;
    
    /**
     * @ORM\OneToMany(targetEntity="HistMatri", mappedBy="estudiante")
     */
    protected $histmatri;
    
    /**
     * @ORM\OneToMany(targetEntity="HistMatriEgresado", mappedBy="estudiante")
     */
    protected $histmatriegresado;
    
    /**
     * @ORM\OneToMany(targetEntity="HistEgresado", mappedBy="estudiante")
     */    
    protected $histegresado;
    
    /**
     * @ORM\OneToMany(targetEntity="ValidEstudiante", mappedBy="estudiante")
     */
    protected $validestud;

    /**
     * @ORM\ManyToOne(targetEntity="SubSede", inversedBy="estudiante")
     * @ORM\JoinColumn(name="subsede_id", referencedColumnName="id")
     */
    protected $subsede;
    
    /**
     * @ORM\Column(type="float", scale=2, nullable=true)
     */
    protected $indice;
    
    /**
     * @ORM\OneToMany(targetEntity="ControlPagos", mappedBy="estudiante")
     */
    protected $controlpagos;
    
    /**
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\Exonerados", mappedBy="especialidadEstudiante")
     */
    protected $exonerados;




    // METODOS GENERADOS PARA LAS CONSULTAS // 
    
    

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->matricula = new \Doctrine\Common\Collections\ArrayCollection();
        $this->depositos = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatri = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatriegresado = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histegresado = new \Doctrine\Common\Collections\ArrayCollection();
        $this->validestud = new \Doctrine\Common\Collections\ArrayCollection();
        $this->controlpagos = new \Doctrine\Common\Collections\ArrayCollection();
        $this->exonerados = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set fechaIngreso
     *
     * @param \DateTime $fechaIngreso
     *
     * @return EspeEstud
     */
    public function setFechaIngreso($fechaIngreso)
    {
        $this->fecha_ingreso = $fechaIngreso;

        return $this;
    }

    /**
     * Get fechaIngreso
     *
     * @return \DateTime
     */
    public function getFechaIngreso()
    {
        return $this->fecha_ingreso;
    }

    /**
     * Set activo
     *
     * @param boolean $activo
     *
     * @return EspeEstud
     */
    public function setActivo($activo)
    {
        $this->activo = $activo;

        return $this;
    }

    /**
     * Get activo
     *
     * @return boolean
     */
    public function getActivo()
    {
        return $this->activo;
    }

    /**
     * Set observacion
     *
     * @param string $observacion
     *
     * @return EspeEstud
     */
    public function setObservacion($observacion)
    {
        $this->observacion = $observacion;

        return $this;
    }

    /**
     * Get observacion
     *
     * @return string
     */
    public function getObservacion()
    {
        return $this->observacion;
    }

    /**
     * Set indice
     *
     * @param float $indice
     *
     * @return EspeEstud
     */
    public function setIndice($indice)
    {
        $this->indice = $indice;

        return $this;
    }

    /**
     * Get indice
     *
     * @return float
     */
    public function getIndice()
    {
        return $this->indice;
    }

    /**
     * Set estudiante
     *
     * @param \AppBundle\Entity\Estudiante $estudiante
     *
     * @return EspeEstud
     */
    public function setEstudiante(\AppBundle\Entity\Estudiante $estudiante = null)
    {
        $this->estudiante = $estudiante;

        return $this;
    }

    /**
     * Get estudiante
     *
     * @return \AppBundle\Entity\Estudiante
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }

    /**
     * Set programa
     *
     * @param \AppBundle\Entity\Programa $programa
     *
     * @return EspeEstud
     */
    public function setPrograma(\AppBundle\Entity\Programa $programa = null)
    {
        $this->programa = $programa;

        return $this;
    }

    /**
     * Get programa
     *
     * @return \AppBundle\Entity\Programa
     */
    public function getPrograma()
    {
        return $this->programa;
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     *
     * @return EspeEstud
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;

        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Set especialidad
     *
     * @param \AppBundle\Entity\Especialidad $especialidad
     *
     * @return EspeEstud
     */
    public function setEspecialidad(\AppBundle\Entity\Especialidad $especialidad = null)
    {
        $this->especialidad = $especialidad;

        return $this;
    }

    /**
     * Get especialidad
     *
     * @return \AppBundle\Entity\Especialidad
     */
    public function getEspecialidad()
    {
        return $this->especialidad;
    }

    /**
     * Set cohorte
     *
     * @param \AppBundle\Entity\Cohorte $cohorte
     *
     * @return EspeEstud
     */
    public function setCohorte(\AppBundle\Entity\Cohorte $cohorte = null)
    {
        $this->cohorte = $cohorte;

        return $this;
    }

    /**
     * Get cohorte
     *
     * @return \AppBundle\Entity\Cohorte
     */
    public function getCohorte()
    {
        return $this->cohorte;
    }

    /**
     * Set ingreso
     *
     * @param \AppBundle\Entity\TipoIngreso $ingreso
     *
     * @return EspeEstud
     */
    public function setIngreso(\AppBundle\Entity\TipoIngreso $ingreso = null)
    {
        $this->ingreso = $ingreso;

        return $this;
    }

    /**
     * Get ingreso
     *
     * @return \AppBundle\Entity\TipoIngreso
     */
    public function getIngreso()
    {
        return $this->ingreso;
    }

    /**
     * Set codLapso
     *
     * @param \AppBundle\Entity\Lapso $codLapso
     *
     * @return EspeEstud
     */
    public function setCodLapso(\AppBundle\Entity\Lapso $codLapso = null)
    {
        $this->cod_lapso = $codLapso;

        return $this;
    }

    /**
     * Get codLapso
     *
     * @return \AppBundle\Entity\Lapso
     */
    public function getCodLapso()
    {
        return $this->cod_lapso;
    }

    /**
     * Set codSitua
     *
     * @param \AppBundle\Entity\CodSitua $codSitua
     *
     * @return EspeEstud
     */
    public function setCodSitua(\AppBundle\Entity\CodSitua $codSitua = null)
    {
        $this->cod_situa = $codSitua;

        return $this;
    }

    /**
     * Get codSitua
     *
     * @return \AppBundle\Entity\CodSitua
     */
    public function getCodSitua()
    {
        return $this->cod_situa;
    }

    /**
     * Add matricula
     *
     * @param \AppBundle\Entity\Matricula $matricula
     *
     * @return EspeEstud
     */
    public function addMatricula(\AppBundle\Entity\Matricula $matricula)
    {
        $this->matricula[] = $matricula;

        return $this;
    }

    /**
     * Remove matricula
     *
     * @param \AppBundle\Entity\Matricula $matricula
     */
    public function removeMatricula(\AppBundle\Entity\Matricula $matricula)
    {
        $this->matricula->removeElement($matricula);
    }

    /**
     * Get matricula
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMatricula()
    {
        return $this->matricula;
    }

    /**
     * Add deposito
     *
     * @param \AppBundle\Entity\Depositos $deposito
     *
     * @return EspeEstud
     */
    public function addDeposito(\AppBundle\Entity\Depositos $deposito)
    {
        $this->depositos[] = $deposito;

        return $this;
    }

    /**
     * Remove deposito
     *
     * @param \AppBundle\Entity\Depositos $deposito
     */
    public function removeDeposito(\AppBundle\Entity\Depositos $deposito)
    {
        $this->depositos->removeElement($deposito);
    }

    /**
     * Get depositos
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDepositos()
    {
        return $this->depositos;
    }

    /**
     * Add histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     *
     * @return EspeEstud
     */
    public function addHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri[] = $histmatri;

        return $this;
    }

    /**
     * Remove histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     */
    public function removeHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri->removeElement($histmatri);
    }

    /**
     * Get histmatri
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getHistmatri()
    {
        return $this->histmatri;
    }

    /**
     * Add histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     *
     * @return EspeEstud
     */
    public function addHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado[] = $histmatriegresado;

        return $this;
    }

    /**
     * Remove histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     */
    public function removeHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado->removeElement($histmatriegresado);
    }

    /**
     * Get histmatriegresado
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getHistmatriegresado()
    {
        return $this->histmatriegresado;
    }

    /**
     * Add histegresado
     *
     * @param \AppBundle\Entity\HistEgresado $histegresado
     *
     * @return EspeEstud
     */
    public function addHistegresado(\AppBundle\Entity\HistEgresado $histegresado)
    {
        $this->histegresado[] = $histegresado;

        return $this;
    }

    /**
     * Remove histegresado
     *
     * @param \AppBundle\Entity\HistEgresado $histegresado
     */
    public function removeHistegresado(\AppBundle\Entity\HistEgresado $histegresado)
    {
        $this->histegresado->removeElement($histegresado);
    }

    /**
     * Get histegresado
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getHistegresado()
    {
        return $this->histegresado;
    }

    /**
     * Add validestud
     *
     * @param \AppBundle\Entity\ValidEstudiante $validestud
     *
     * @return EspeEstud
     */
    public function addValidestud(\AppBundle\Entity\ValidEstudiante $validestud)
    {
        $this->validestud[] = $validestud;

        return $this;
    }

    /**
     * Remove validestud
     *
     * @param \AppBundle\Entity\ValidEstudiante $validestud
     */
    public function removeValidestud(\AppBundle\Entity\ValidEstudiante $validestud)
    {
        $this->validestud->removeElement($validestud);
    }

    /**
     * Get validestud
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getValidestud()
    {
        return $this->validestud;
    }

    /**
     * Set subsede
     *
     * @param \AppBundle\Entity\SubSede $subsede
     *
     * @return EspeEstud
     */
    public function setSubsede(\AppBundle\Entity\SubSede $subsede = null)
    {
        $this->subsede = $subsede;

        return $this;
    }

    /**
     * Get subsede
     *
     * @return \AppBundle\Entity\SubSede
     */
    public function getSubsede()
    {
        return $this->subsede;
    }

    /**
     * Add controlpago
     *
     * @param \AppBundle\Entity\ControlPagos $controlpago
     *
     * @return EspeEstud
     */
    public function addControlpago(\AppBundle\Entity\ControlPagos $controlpago)
    {
        $this->controlpagos[] = $controlpago;

        return $this;
    }

    /**
     * Remove controlpago
     *
     * @param \AppBundle\Entity\ControlPagos $controlpago
     */
    public function removeControlpago(\AppBundle\Entity\ControlPagos $controlpago)
    {
        $this->controlpagos->removeElement($controlpago);
    }

    /**
     * Get controlpagos
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getControlpagos()
    {
        return $this->controlpagos;
    }

    /**
     * Add exonerado
     *
     * @param \AppBundle\Entity\Exonerados $exonerado
     *
     * @return EspeEstud
     */
    public function addExonerado(\AppBundle\Entity\Exonerados $exonerado)
    {
        $this->exonerados[] = $exonerado;

        return $this;
    }

    /**
     * Remove exonerado
     *
     * @param \AppBundle\Entity\Exonerados $exonerado
     */
    public function removeExonerado(\AppBundle\Entity\Exonerados $exonerado)
    {
        $this->exonerados->removeElement($exonerado);
    }

    /**
     * Get exonerados
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getExonerados()
    {
        return $this->exonerados;
    }
}
