<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="hist_matri_egresado")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\HistMatriEgresadoRepository")
 */
class HistMatriEgresado {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="EspeEstud", inversedBy="histmatriegresado")
     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")
     */
    protected $estudiante;
    
    /**
     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="histmatriegresado")
     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")
     */
    protected $lapso;
    
    /**
     * @ORM\ManyToOne(targetEntity="Cursos", inversedBy="histmatriegresado")
     * @ORM\JoinColumn(name="curso_id", referencedColumnName="id")
     */
    protected $curso;
    
    /**
     * @ORM\Column(type="string", length=20)
     */
    protected $seccion;
    
    /**
     * @ORM\Column(type="string", length=1)
     */
    protected $grupo;
    
    /**
     * @ORM\Column(type="integer", length=2)
     */
    protected $nota;
    
    /**
     * @ORM\ManyToOne(targetEntity="CondCurso", inversedBy="histmatriegresado")
     * @ORM\JoinColumn(name="condicion_id", referencedColumnName="id")
     */
    protected $condicion;
    
    /**
     * @ORM\Column(type="integer", length=1)
     */
    protected $uc;
    
    /**
     * @ORM\Column(type="string")
     */
    protected $obs;
    
    /**
     * @ORM\ManyToOne(targetEntity="Programa", inversedBy="histmatriegresado")
     * @ORM\JoinColumn(name="programa_id", referencedColumnName="id")
     */
    protected $programa;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="histmatriegresado")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
    /**
     * @ORM\ManyToOne(targetEntity="Especialidad", inversedBy="histmatriegresado")
     * @ORM\JoinColumn(name="especialidad_id", referencedColumnName="id")
     */
    protected $especialidad;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sessiones", inversedBy="histmatriegresado")
     * @ORM\JoinColumn(name="session_id", referencedColumnName="id")
     */
    protected $session;
    /**
     * @ORM\ManyToOne(targetEntity="SubSede", inversedBy="histmatriegresado")
     * @ORM\JoinColumn(name="subsede_id", referencedColumnName="id")
     */
    protected $subsede;
    
    // METODOS GENERADOS PARA LAS CONSULTAS //
   

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set seccion
     *
     * @param string $seccion
     * @return HistMatriEgresado
     */
    public function setSeccion($seccion)
    {
        $this->seccion = $seccion;
    
        return $this;
    }

    /**
     * Get seccion
     *
     * @return string 
     */
    public function getSeccion()
    {
        return $this->seccion;
    }

    /**
     * Set grupo
     *
     * @param string $grupo
     * @return HistMatriEgresado
     */
    public function setGrupo($grupo)
    {
        $this->grupo = $grupo;
    
        return $this;
    }

    /**
     * Get grupo
     *
     * @return string 
     */
    public function getGrupo()
    {
        return $this->grupo;
    }

    /**
     * Set nota
     *
     * @param integer $nota
     * @return HistMatriEgresado
     */
    public function setNota($nota)
    {
        $this->nota = $nota;
    
        return $this;
    }

    /**
     * Get nota
     *
     * @return integer 
     */
    public function getNota()
    {
        return $this->nota;
    }

    /**
     * Set uc
     *
     * @param integer $uc
     * @return HistMatriEgresado
     */
    public function setUc($uc)
    {
        $this->uc = $uc;
    
        return $this;
    }

    /**
     * Get uc
     *
     * @return integer 
     */
    public function getUc()
    {
        return $this->uc;
    }

    /**
     * Set obs
     *
     * @param string $obs
     * @return HistMatriEgresado
     */
    public function setObs($obs)
    {
        $this->obs = $obs;
    
        return $this;
    }

    /**
     * Get obs
     *
     * @return string 
     */
    public function getObs()
    {
        return $this->obs;
    }

    /**
     * Set estudiante
     *
     * @param \AppBundle\Entity\EspeEstud $estudiante
     * @return HistMatriEgresado
     */
    public function setEstudiante(\AppBundle\Entity\EspeEstud $estudiante = null)
    {
        $this->estudiante = $estudiante;
    
        return $this;
    }

    /**
     * Get estudiante
     *
     * @return \AppBundle\Entity\EspeEstud 
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }

    /**
     * Set lapso
     *
     * @param \AppBundle\Entity\Lapso $lapso
     * @return HistMatriEgresado
     */
    public function setLapso(\AppBundle\Entity\Lapso $lapso = null)
    {
        $this->lapso = $lapso;
    
        return $this;
    }

    /**
     * Get lapso
     *
     * @return \AppBundle\Entity\Lapso 
     */
    public function getLapso()
    {
        return $this->lapso;
    }

    /**
     * Set curso
     *
     * @param \AppBundle\Entity\Cursos $curso
     * @return HistMatriEgresado
     */
    public function setCurso(\AppBundle\Entity\Cursos $curso = null)
    {
        $this->curso = $curso;
    
        return $this;
    }

    /**
     * Get curso
     *
     * @return \AppBundle\Entity\Cursos 
     */
    public function getCurso()
    {
        return $this->curso;
    }

    /**
     * Set condicion
     *
     * @param \AppBundle\Entity\CondCurso $condicion
     * @return HistMatriEgresado
     */
    public function setCondicion(\AppBundle\Entity\CondCurso $condicion = null)
    {
        $this->condicion = $condicion;
    
        return $this;
    }

    /**
     * Get condicion
     *
     * @return \AppBundle\Entity\CondCurso 
     */
    public function getCondicion()
    {
        return $this->condicion;
    }

    /**
     * Set programa
     *
     * @param \AppBundle\Entity\Programa $programa
     * @return HistMatriEgresado
     */
    public function setPrograma(\AppBundle\Entity\Programa $programa = null)
    {
        $this->programa = $programa;
    
        return $this;
    }

    /**
     * Get programa
     *
     * @return \AppBundle\Entity\Programa 
     */
    public function getPrograma()
    {
        return $this->programa;
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     * @return HistMatriEgresado
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Set especialidad
     *
     * @param \AppBundle\Entity\Especialidad $especialidad
     * @return HistMatriEgresado
     */
    public function setEspecialidad(\AppBundle\Entity\Especialidad $especialidad = null)
    {
        $this->especialidad = $especialidad;
    
        return $this;
    }

    /**
     * Get especialidad
     *
     * @return \AppBundle\Entity\Especialidad 
     */
    public function getEspecialidad()
    {
        return $this->especialidad;
    }

    /**
     * Set session
     *
     * @param \AppBundle\Entity\Sessiones $session
     * @return HistMatriEgresado
     */
    public function setSession(\AppBundle\Entity\Sessiones $session = null)
    {
        $this->session = $session;
    
        return $this;
    }

    /**
     * Get session
     *
     * @return \AppBundle\Entity\Sessiones 
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * Set subsede
     *
     * @param \AppBundle\Entity\SubSede $subsede
     *
     * @return HistMatriEgresado
     */
    public function setSubsede(\AppBundle\Entity\SubSede $subsede = null)
    {
        $this->subsede = $subsede;

        return $this;
    }

    /**
     * Get subsede
     *
     * @return \AppBundle\Entity\SubSede
     */
    public function getSubsede()
    {
        return $this->subsede;
    }
}
