<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Security\Core\User\UserInterface;

/**
 * @ORM\Table(name="profesor")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\ProfesorRepository")
 */
class Profesor implements UserInterface {
     /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=20, unique=true)
     */
    protected $cedula;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $primer_nombre;
    
    /**
     * @ORM\Column(type="string", length=50, nullable=true)
     */
    protected $segundo_nombre;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $primer_apellido;
    
    /**
     * @ORM\Column(type="string", length=50, nullable=true)
     */
    protected $segundo_apellido;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $nacionalidad;
    
    /**
     * @ORM\Column(type="date")
     */
    protected $fecha_nacimiento;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $lugar_nacimiento;
    
    /**
     * @ORM\Column(type="string", length=20)
     */
    protected $sexo;
    
    /**
     * @ORM\Column(type="string", length=20)
     */
    protected $estado_civil;
    
    /**
     * @ORM\Column(type="text", nullable=true)
     */
    protected $direccion;
    
    /**
     * @ORM\Column(type="string", length=12, nullable=true)
     */
    protected $telefono_movil;
    
    /**
     * @ORM\Column(type="string", length=12, nullable=true)
     */
    protected $telefono_local;
    
    /**
     * @ORM\Column(type="string")
     */
    protected $email;
    
    /**
     * @ORM\Column(type="string", nullable=true)
     */
    protected $salf;
    
    /**
     * @ORM\Column(type="string", nullable=true)
     */
    protected $password;
    
    /**
     * @ORM\OneToMany(targetEntity="OfertAcade", mappedBy="profesor")
     */
    protected $oferacade;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="profesor")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;

    /**
     * @ORM\Column(type="boolean")
     */
    protected $activo;


    // METODOS GENERADOS PARA LAS CONSULTAS //

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set cedula
     *
     * @param string $cedula
     * @return Profesor
     */
    public function setCedula($cedula)
    {
        $this->cedula = $cedula;
    
        return $this;
    }

    /**
     * Get cedula
     *
     * @return string 
     */
    public function getCedula()
    {
        return $this->cedula;
    }

    /**
     * Set primer_nombre
     *
     * @param string $primerNombre
     * @return Profesor
     */
    public function setPrimerNombre($primerNombre)
    {
        $this->primer_nombre = $primerNombre;
    
        return $this;
    }

    /**
     * Get primer_nombre
     *
     * @return string 
     */
    public function getPrimerNombre()
    {
        return $this->primer_nombre;
    }

    /**
     * Set segundo_nombre
     *
     * @param string $segundoNombre
     * @return Profesor
     */
    public function setSegundoNombre($segundoNombre)
    {
        $this->segundo_nombre = $segundoNombre;
    
        return $this;
    }

    /**
     * Get segundo_nombre
     *
     * @return string 
     */
    public function getSegundoNombre()
    {
        return $this->segundo_nombre;
    }

    /**
     * Set primer_apellido
     *
     * @param string $primerApellido
     * @return Profesor
     */
    public function setPrimerApellido($primerApellido)
    {
        $this->primer_apellido = $primerApellido;
    
        return $this;
    }

    /**
     * Get primer_apellido
     *
     * @return string 
     */
    public function getPrimerApellido()
    {
        return $this->primer_apellido;
    }

    /**
     * Set segundo_apellido
     *
     * @param string $segundoApellido
     * @return Profesor
     */
    public function setSegundoApellido($segundoApellido)
    {
        $this->segundo_apellido = $segundoApellido;
    
        return $this;
    }

    /**
     * Get segundo_apellido
     *
     * @return string 
     */
    public function getSegundoApellido()
    {
        return $this->segundo_apellido;
    }

    /**
     * Set nacionalidad
     *
     * @param string $nacionalidad
     * @return Profesor
     */
    public function setNacionalidad($nacionalidad)
    {
        $this->nacionalidad = $nacionalidad;
    
        return $this;
    }

    /**
     * Get nacionalidad
     *
     * @return string 
     */
    public function getNacionalidad()
    {
        return $this->nacionalidad;
    }

    /**
     * Set fecha_nacimiento
     *
     * @param \DateTime $fechaNacimiento
     * @return Profesor
     */
    public function setFechaNacimiento($fechaNacimiento)
    {
        $this->fecha_nacimiento = $fechaNacimiento;
    
        return $this;
    }

    /**
     * Get fecha_nacimiento
     *
     * @return \DateTime 
     */
    public function getFechaNacimiento()
    {
        return $this->fecha_nacimiento;
    }

    /**
     * Set lugar_nacimiento
     *
     * @param string $lugarNacimiento
     * @return Profesor
     */
    public function setLugarNacimiento($lugarNacimiento)
    {
        $this->lugar_nacimiento = $lugarNacimiento;
    
        return $this;
    }

    /**
     * Get lugar_nacimiento
     *
     * @return string 
     */
    public function getLugarNacimiento()
    {
        return $this->lugar_nacimiento;
    }

    /**
     * Set sexo
     *
     * @param string $sexo
     * @return Profesor
     */
    public function setSexo($sexo)
    {
        $this->sexo = $sexo;
    
        return $this;
    }

    /**
     * Get sexo
     *
     * @return string 
     */
    public function getSexo()
    {
        return $this->sexo;
    }

    /**
     * Set direccion
     *
     * @param string $direccion
     * @return Profesor
     */
    public function setDireccion($direccion)
    {
        $this->direccion = $direccion;
    
        return $this;
    }

    /**
     * Get direccion
     *
     * @return string 
     */
    public function getDireccion()
    {
        return $this->direccion;
    }

    /**
     * Set telefono_movil
     *
     * @param string $telefonoMovil
     * @return Profesor
     */
    public function setTelefonoMovil($telefonoMovil)
    {
        $this->telefono_movil = $telefonoMovil;
    
        return $this;
    }

    /**
     * Get telefono_movil
     *
     * @return string 
     */
    public function getTelefonoMovil()
    {
        return $this->telefono_movil;
    }

    /**
     * Set telefono_local
     *
     * @param string $telefonoLocal
     * @return Profesor
     */
    public function setTelefonoLocal($telefonoLocal)
    {
        $this->telefono_local = $telefonoLocal;
    
        return $this;
    }

    /**
     * Get telefono_local
     *
     * @return string 
     */
    public function getTelefonoLocal()
    {
        return $this->telefono_local;
    }

    /**
     * Set email
     *
     * @param string $email
     * @return Profesor
     */
    public function setEmail($email)
    {
        $this->email = $email;
    
        return $this;
    }

    /**
     * Get email
     *
     * @return email 
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->oferacade = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add oferacade
     *
     * @param AppBundle\Entity\OfertAcade $oferacade
     * @return Profesor
     */
    public function addOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade[] = $oferacade;
    
        return $this;
    }

    /**
     * Remove oferacade
     *
     * @param AppBundle\Entity\OfertAcade $oferacade
     */
    public function removeOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade->removeElement($oferacade);
    }

    /**
     * Get oferacade
     *
     * @return Doctrine\Common\Collections\Collection 
     */
    public function getOferacade()
    {
        return $this->oferacade;
    }
    
    //Metodo para devolver informacion
    
    public function __toString(){
        return $this->getPrimerNombre().' '.$this->getPrimerApellido();
    }

    /**
     * Set sede
     *
     * @param \AppBundle\Entity\Sede $sede
     * @return Profesor
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return \AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Set estado_civil
     *
     * @param string $estadoCivil
     * @return Profesor
     */
    public function setEstadoCivil($estadoCivil)
    {
        $this->estado_civil = $estadoCivil;
    
        return $this;
    }

    /**
     * Get estado_civil
     *
     * @return string 
     */
    public function getEstadoCivil()
    {
        return $this->estado_civil;
    }

    /**
     * Set salf
     *
     * @param string $salf
     * @return Profesor
     */
    public function setSalf($salf)
    {
        $this->salf = $salf;
    
        return $this;
    }

    /**
     * Get salf
     *
     * @return string 
     */
    public function getSalf()
    {
        return $this->salf;
    }

    /**
     * Set password
     *
     * @param string $password
     * @return Profesor
     */
    public function setPassword($password)
    {
        $this->password = $password;
    
        return $this;
    }

    /**
     * Get password
     *
     * @return string 
     */
    public function getPassword()
    {
        return $this->password;
    }

    public function eraseCredentials() {
        
    }

    public function getRoles() {
        return array('ROLE_PROF');
    }

    public function getSalt() {
        
    }

    public function getUsername() {
        return $this->getPrimerNombre().' '.$this->getPrimerApellido();
    }


    /**
     * Set activo
     *
     * @param boolean $activo
     *
     * @return SubSede
     */
    public function setActivo($activo)
    {
        $this->activo = $activo;

        return $this;
    }

    /**
     * Get activo
     *
     * @return boolean
     */
    public function getActivo()
    {
        return $this->activo;
    }


    
}
