<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="programa")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\ProgramaRepository")
 */
class Programa {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=15)
     */
    protected $codigo;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $nombre;
    
    /**
     * @ORM\OneToMany(targetEntity="EspeEstud", mappedBy="programa")
     */
    protected $espeestud;

    /**
     * @ORM\OneToMany(targetEntity="PlanEstudio", mappedBy="programa")
     */
    protected $planestudio;

    /**
     * @ORM\OneToMany(targetEntity="OfertAcade", mappedBy="programa")
     */
    protected $oferacade;
    
    /**
     * @ORM\OneToMany(targetEntity="HistMatri", mappedBy="programa")
     */
    protected $histmatri;
    
    /**
     * @ORM\OneToMany(targetEntity="HistMatriEgresado", mappedBy="programa")
     */
    protected $histmatriegresado;
    
    /**
     * @ORM\OneToMany(targetEntity="Especialidad", mappedBy="programa")
     */
    protected $especialidad;
    
    /**
     * @ORM\OneToMany(targetEntity="MontoCurso", mappedBy="programa")
     */
    protected $montocurso;
    
    /**
     * @ORM\OneToMany(targetEntity="ConfigSistema", mappedBy="programa")
     */
    protected $config;



// METODOS GENARADOS PARA LAS CONSULTAS //
    
    
    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->espeestud = new \Doctrine\Common\Collections\ArrayCollection();
        $this->planestudio = new \Doctrine\Common\Collections\ArrayCollection();
        $this->oferacade = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatri = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatriegresado = new \Doctrine\Common\Collections\ArrayCollection();
        $this->especialidad = new \Doctrine\Common\Collections\ArrayCollection();
        $this->montocurso = new \Doctrine\Common\Collections\ArrayCollection();
        $this->config = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     * @return Programa
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    
        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     * @return Programa
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    
        return $this;
    }

    /**
     * Get nombre
     *
     * @return string 
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Add espeestud
     *
     * @param \AppBundle\Entity\EspeEstud $espeestud
     * @return Programa
     */
    public function addEspeestud(\AppBundle\Entity\EspeEstud $espeestud)
    {
        $this->espeestud[] = $espeestud;
    
        return $this;
    }

    /**
     * Remove espeestud
     *
     * @param \AppBundle\Entity\EspeEstud $espeestud
     */
    public function removeEspeestud(\AppBundle\Entity\EspeEstud $espeestud)
    {
        $this->espeestud->removeElement($espeestud);
    }

    /**
     * Get espeestud
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getEspeestud()
    {
        return $this->espeestud;
    }

    /**
     * Add planestudio
     *
     * @param \AppBundle\Entity\PlanEstudio $planestudio
     * @return Programa
     */
    public function addPlanestudio(\AppBundle\Entity\PlanEstudio $planestudio)
    {
        $this->planestudio[] = $planestudio;
    
        return $this;
    }

    /**
     * Remove planestudio
     *
     * @param \AppBundle\Entity\PlanEstudio $planestudio
     */
    public function removePlanestudio(\AppBundle\Entity\PlanEstudio $planestudio)
    {
        $this->planestudio->removeElement($planestudio);
    }

    /**
     * Get planestudio
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getPlanestudio()
    {
        return $this->planestudio;
    }

    /**
     * Add oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     * @return Programa
     */
    public function addOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade[] = $oferacade;
    
        return $this;
    }

    /**
     * Remove oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     */
    public function removeOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade->removeElement($oferacade);
    }

    /**
     * Get oferacade
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getOferacade()
    {
        return $this->oferacade;
    }

    /**
     * Add histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     * @return Programa
     */
    public function addHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri[] = $histmatri;
    
        return $this;
    }

    /**
     * Remove histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     */
    public function removeHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri->removeElement($histmatri);
    }

    /**
     * Get histmatri
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHistmatri()
    {
        return $this->histmatri;
    }

    /**
     * Add histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     * @return Programa
     */
    public function addHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado[] = $histmatriegresado;
    
        return $this;
    }

    /**
     * Remove histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     */
    public function removeHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado->removeElement($histmatriegresado);
    }

    /**
     * Get histmatriegresado
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHistmatriegresado()
    {
        return $this->histmatriegresado;
    }

    /**
     * Add especialidad
     *
     * @param \AppBundle\Entity\Especialidad $especialidad
     * @return Programa
     */
    public function addEspecialidad(\AppBundle\Entity\Especialidad $especialidad)
    {
        $this->especialidad[] = $especialidad;
    
        return $this;
    }

    /**
     * Remove especialidad
     *
     * @param \AppBundle\Entity\Especialidad $especialidad
     */
    public function removeEspecialidad(\AppBundle\Entity\Especialidad $especialidad)
    {
        $this->especialidad->removeElement($especialidad);
    }

    /**
     * Get especialidad
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getEspecialidad()
    {
        return $this->especialidad;
    }

    /**
     * Add montocurso
     *
     * @param \AppBundle\Entity\MontoCurso $montocurso
     * @return Programa
     */
    public function addMontocurso(\AppBundle\Entity\MontoCurso $montocurso)
    {
        $this->montocurso[] = $montocurso;
    
        return $this;
    }

    /**
     * Remove montocurso
     *
     * @param \AppBundle\Entity\MontoCurso $montocurso
     */
    public function removeMontocurso(\AppBundle\Entity\MontoCurso $montocurso)
    {
        $this->montocurso->removeElement($montocurso);
    }

    /**
     * Get montocurso
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getMontocurso()
    {
        return $this->montocurso;
    }

    /**
     * Add config
     *
     * @param \AppBundle\Entity\ConfigSistema $config
     * @return Programa
     */
    public function addConfig(\AppBundle\Entity\ConfigSistema $config)
    {
        $this->config[] = $config;
    
        return $this;
    }

    /**
     * Remove config
     *
     * @param \AppBundle\Entity\ConfigSistema $config
     */
    public function removeConfig(\AppBundle\Entity\ConfigSistema $config)
    {
        $this->config->removeElement($config);
    }

    /**
     * Get config
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getConfig()
    {
        return $this->config;
    }
    
    public function __toString() {
        return $this->getNombre();
    }
}
