<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * HistMatriRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class HistMatriRepository extends EntityRepository
{
    public function materiasAprobadas($estudiante)
    {
        $matAprobadas = $this->getEntityManager()->createQuery("
            SELECT h.curso FROM AppBundle:HistMatri h 
            WHERE h.condicion = :condicion AND 
                  h.estudiante = :estudiante
            ")->setParameter('condicion', 3)
              ->setParameter('estudiante', $estudiante)->getResult();
        return $matAprobadas;
    }
    
    public function findCursos($estudiante)
    {
        $query = $this->getEntityManager()->
                createQuery("SELECT h FROM AppBundle:HistMatri h 
                             WHERE h.estudiante = :estudiante 
                             ORDER BY h.lapso ASC")
                             ->setParameter('estudiante', $estudiante)
                ;
        return $query->getResult();
    }
    
    public function findAllMateriasAprobadas($estudiante)
    {
        $matAprobadas = $this->getEntityManager()->createQuery("
            SELECT h FROM AppBundle:HistMatri h 
            WHERE (h.condicion = :condicion OR h.condicion =:condicion2 OR h.condicion = :condicion3) AND   
                  h.estudiante = :estudiante
            ")
                ->setParameter('condicion', 3)
                ->setParameter('condicion2', 7)
                ->setParameter('condicion3', 10)
              ->setParameter('estudiante', $estudiante->getId())->getResult();
        return $matAprobadas;
    }
    
}
