<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

use AppBundle\Entity\EspeEstud;


/**
 * SaldoEstudiante
 *
 * @ORM\Table(name="saldo_estudiante")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\SaldoEstudianteRepository")
 */
class SaldoEstudiante
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="monto", type="decimal", scale=2)
     */
    private $monto;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fechaCreacion", type="datetime")
     */
    private $fechaCreacion;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fechaActualizacion", type="datetime")
     */
    private $fechaActualizacion;
    
     /**
     * @var AppBundle\Entity\EspeEstud especialidadEstudiante
     * @ORM\OneToOne(targetEntity="AppBundle\Entity\EspeEstud",
     *     mappedBy="saldoEstudiante", cascade={"persist", "remove"})
     * @ORM\JoinColumn(name="espeestud_id", referencedColumnName="id")
     */
     
    private $especialidadEstudiante;
    


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set monto
     *
     * @param string $monto
     * @return SaldoEstudiante
     */
    public function setMonto($monto)
    {
        $this->monto = $monto;
    
        return $this;
    }

    /**
     * Get monto
     *
     * @return string 
     */
    public function getMonto()
    {
        return $this->monto;
    }

    /**
     * Set fechaCreacion
     *
     * @param \DateTime $fechaCreacion
     * @return SaldoEstudiante
     */
    public function setFechaCreacion(\DateTime $fechaCreacion)
    {
        $this->fechaCreacion = $fechaCreacion;
    
        return $this;
    }

    /**
     * Get fechaCreacion
     *
     * @return \DateTime 
     */
    public function getFechaCreacion()
    {
        return $this->fechaCreacion;
    }

    /**
     * Set fechaActualizacion
     *
     * @param \DateTime $fechaActualizacion
     * @return SaldoEstudiante
     */
    public function setFechaActualizacion($fechaActualizacion)
    {
        $this->fechaActualizacion = $fechaActualizacion;
    
        return $this;
    }

    /**
     * Get fechaActualizacion
     *
     * @return \DateTime 
     */
    public function getFechaActualizacion()
    {
        return $this->fechaActualizacion;
    }

    /**
     * Set EspeEstud
     *
     * @param \AppBundle\Entity\EspeEstud $espeestud
     */
    public function setEspeEstud(EspeEstud $espeestud = null) {
        $this->especialidadEstudiante = $espeestud;
    }

    /**
     * Get EspeEstud
     *
     * @return \AppBundle\Entity\EspeEstud
     */
    public function getEstudiante() {
        return $this->especialidadEstudiante;
    }


    /**
     * Set especialidadEstudiante
     *
     * @param \AppBundle\Entity\EspeEstud $especialidadEstudiante
     * @return SaldoEstudiante
     */
    public function setEspecialidadEstudiante(\AppBundle\Entity\EspeEstud $especialidadEstudiante = null)
    {
        $this->especialidadEstudiante = $especialidadEstudiante;
    
        return $this;
    }

    /**
     * Get especialidadEstudiante
     *
     * @return \AppBundle\Entity\EspeEstud 
     */
    public function getEspecialidadEstudiante()
    {
        return $this->especialidadEstudiante;
    }
}
