<?php


namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="sub_sedes")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\SubSedesRepository")
 */
class SubSedes {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=100)
     */
    protected $nombre;
    

    
    /**
     * @ORM\OneToMany(targetEntity="EspeEstud", mappedBy="subsedes")
     */
    protected $estudiante;
    
    /**
     * @ORM\OneToMany(targetEntity="ExtensionesUsuarios", mappedBy="subsedes")
     */
    protected $extensiones;
    
    /**
     * @ORM\OneToMany(targetEntity="OfertAcade", mappedBy="subsedes")
     */
    protected $oferacade;

  
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->estudiante = new \Doctrine\Common\Collections\ArrayCollection();
        $this->extensiones = new \Doctrine\Common\Collections\ArrayCollection();
        $this->oferacade = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     *
     * @return SubSedes
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;

        return $this;
    }

    /**
     * Get nombre
     *
     * @return string
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Add estudiante
     *
     * @param \AppBundle\Entity\EspeEstud $estudiante
     *
     * @return SubSedes
     */
    public function addEstudiante(\AppBundle\Entity\EspeEstud $estudiante)
    {
        $this->estudiante[] = $estudiante;

        return $this;
    }

    /**
     * Remove estudiante
     *
     * @param \AppBundle\Entity\EspeEstud $estudiante
     */
    public function removeEstudiante(\AppBundle\Entity\EspeEstud $estudiante)
    {
        $this->estudiante->removeElement($estudiante);
    }

    /**
     * Get estudiante
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }

    /**
     * Add extensione
     *
     * @param \AppBundle\Entity\ExtensionesUsuarios $extensione
     *
     * @return SubSedes
     */
    public function addExtensione(\AppBundle\Entity\ExtensionesUsuarios $extensione)
    {
        $this->extensiones[] = $extensione;

        return $this;
    }

    /**
     * Remove extensione
     *
     * @param \AppBundle\Entity\ExtensionesUsuarios $extensione
     */
    public function removeExtensione(\AppBundle\Entity\ExtensionesUsuarios $extensione)
    {
        $this->extensiones->removeElement($extensione);
    }

    /**
     * Get extensiones
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getExtensiones()
    {
        return $this->extensiones;
    }

    /**
     * Add oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     *
     * @return SubSedes
     */
    public function addOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade[] = $oferacade;

        return $this;
    }

    /**
     * Remove oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     */
    public function removeOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade->removeElement($oferacade);
    }

    /**
     * Get oferacade
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOferacade()
    {
        return $this->oferacade;
    }
      public function __toString()
    {
        return $this->nombre;}
}
