<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="tipocursos")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\TipoCursosRepository")
 */
class TipoCursos {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=20, unique=true)
     */
    protected $codigo;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $descripcion;
    /**
     * @ORM\Column(type="boolean")
     */
    protected $vigente;

    /**
     * @ORM\OneToMany(targetEntity="Cursos", mappedBy="tipocursos")
     */
    protected $tipocursos;
    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->cursos = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     *
     * @return TipoCursos
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set descripcion
     *
     * @param string $descripcion
     *
     * @return TipoCursos
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;

        return $this;
    }

    /**
     * Get descripcion
     *
     * @return string
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * Set vigente
     *
     * @param boolean $vigente
     *
     * @return TipoCursos
     */
    public function setVigente($vigente)
    {
        $this->vigente = $vigente;

        return $this;
    }

    /**
     * Get vigente
     *
     * @return boolean
     */
    public function getVigente()
    {
        return $this->vigente;
    }

    /**
     * Add cursos
     *
     * @param \AppBundle\Entity\Cursos $cursos
     *
     * @return TipoCursos
     */
    public function addCursos(\AppBundle\Entity\Cursos $cursos)
    {
        $this->cursos[] = $cursos;

        return $this;
    }

    /**
     * Remove cursos
     *
     * @param \AppBundle\Entity\Cursos $cursos
     */
    public function removeCursos(\AppBundle\Entity\Cursos $cursos)
    {
        $this->cursos->removeElement($cursos);
    }

    /**
     * Get cursos
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCursos()
    {
        return $this->cursos;
    }

    public function __toString()
    {
        return $this->descripcion;
    }


    /**
     * Add tipocurso
     *
     * @param \AppBundle\Entity\Cursos $tipocurso
     *
     * @return TipoCursos
     */
    public function addTipocurso(\AppBundle\Entity\Cursos $tipocurso)
    {
        $this->tipocursos[] = $tipocurso;

        return $this;
    }

    /**
     * Remove tipocurso
     *
     * @param \AppBundle\Entity\Cursos $tipocurso
     */
    public function removeTipocurso(\AppBundle\Entity\Cursos $tipocurso)
    {
        $this->tipocursos->removeElement($tipocurso);
    }

    /**
     * Get tipocursos
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getTipocursos()
    {
        return $this->tipocursos;
    }
}
