<?php
namespace AppBundle\Controller;


use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Entity\Asesoria;
use AppBundle\Entity\Sessiones;
use AppBundle\Utils\ReporteLayout;
/**
 * Description of AsesoriaController
 *
 * @author jose
 */
class AsesoriaController extends Controller {
    //put your code here
    
    /**
     * @Route("/app/admin/consult/estud/asesoria", name="app_admin_consul_estud_asesoria")
     */
    public function indexAction()
    {
        $form = $this->formSearchEstudiante();
        return $this->render('AppBundle:Asesoria:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }    
    
    private function formSearchEstudiante()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_result_estud_asesoria'))
                ->setMethod('GET')
                ->add('cedula', 'text', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm()
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/result/estud/asesoria", name="app_admin_result_estud_asesoria", requirements={"_method":"GET"})
     */
    public function searchEstudiantesAction(Request $request)
    {
        $form = $this->formSearchEstudiante();

        $fecha = new \DateTime();
        $fechanow = $fecha->format('Y-m-d');
        $activo = '';
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $estudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
            
            $ids = $this->getUser()->getSede()->getCodigo();
            $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);

            $lapsos= $em->getRepository('AppBundle:Procesos')->findProcesoI($fechanow);

            if(!$lapsos){
                $this->get('session')->getFlashBag()->add('msg-error', 'PROCESO DE ASESORÍA CERRADO');
                return $this->redirect($this->generateUrl('app_admin_consul_estud_asesoria'));
            }
            
            if(!$estudiante){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_admin_result_estud_asesoria'));
            }

            $espeestud = $em->getRepository('AppBundle:EspeEstud')->findOneBy(array('estudiante'=>$estudiante->getId()));

            $codact = $em->getRepository('AppBundle:EspeEstud')->findOneByActivo($estudiante->getId());

            foreach ($codact as $value ){
                if($value->getActivo() == 1){
                    $activo = $value->getActivo();
                }
            }

            if(!$activo){
            $this->get('session')->getFlashBag()->add('msg-error',$estudiante->getId().' Estudiante Inactivo');
                return $this->redirect($this->generateUrl('app_admin_result_estud_asesoria'));
            }
            
            return $this->render('AppBundle:Asesoria:result.html.twig', array(
                'datos'=>$estudiante,
                'lapsos'=>$lapsos
            ));
        }
        
        return $this->render('AppBundle:Asesoria:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/asesoria/", name="app_admin_estudiante_asesoria")
     */
    public function asesoriaEstudianteAction(Request $request)
    {
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $fecha = new \DateTime();
        $fechanow = $fecha->format('Y-m-d');
        $activo = $em->getRepository('AppBundle:Procesos')->findProcesoI($fechanow);

        foreach ($activo as $act){

            $lapso = $act->getLapso()->getId();
            $lapsoac = $em->getRepository('AppBundle:Lapso')->find($lapso);

            $especialidad = $request->get('especialidad');
            $espeestud = $em->getRepository('AppBundle:EspeEstud')->find($especialidad);
            $subsede = $espeestud->getSubsede();
            $lapsocodigo = $lapsoac->getCodigo();
            $cohorteespe = $espeestud->getCohorte()->getId();
            
            $programa = $espeestud->getPrograma();
            $configPrograma = $em->getRepository('AppBundle:ConfigSistema')->findOneBy(array('programa'=>$programa->getId()));                
            $procesos = $em->getRepository('AppBundle:Procesos')->findProcesoI($fechanow);
            $especialidadOb =  $em->getRepository('AppBundle:Especialidad')->find($especialidad);
                    
            
            /*if(!$procesos){
                $this->get('session')->getFlashBag()->add('msg-error', 'Proceso cerrado para la fecha actual');
                return $this->redirect($request->headers->get('referer'));
            }*/
            
            
            
            $planestudios=$em->getRepository('AppBundle:PlanEstudio')->consultMaterias($programa, $espeestud->getEspecialidad(), $subsede->getSede());
            
            $cursosAprobados=$em->getRepository('AppBundle:Matricula')->findMatriculaEstudAprob($espeestud);


            $cursosAplazados=$em->getRepository('AppBundle:Matricula')->findMatriculaEstudAplazado($espeestud);



                            
            $cursosOfertados = $em->getRepository('AppBundle:OfertAcade')->findCursoOfertadoNew($espeestud->getEspecialidad()->getId(), $lapsoac->getId(), 0, $especialidad, $subsede);
            $cursosInscritos = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($especialidad, $lapsoac->getId());
            
    	    $cursosasesorados = $em->getRepository('AppBundle:Asesoria')->findBy(array('lapso'=>$lapsoac->getId(),  'estudiante'=>$especialidad));
	   }
       
        
        $oferta = array();
        foreach ($cursosOfertados as $p ){
            $oferta[] = array(
                    'idc'      =>$p->getId(),
                    'codc'     =>$p->getCodigo(),
                    'nombrec'  => $p->getNombre()
                );
        }
		
        $asesorados = array();
        foreach ($cursosasesorados as $p ){
            $asesorados[] = array(
                    'idc'      =>$p->getCurso()->getId(),
                    'codc'     =>$p->getCurso()->getCodigo(),
                    'nombrec'  => $p->getCurso()->getNombre()
                );
        }



        $aprobados = array();
        foreach ($cursosAprobados as $p ){

            if($p->getTraslado()){

                $aprobados[] = array(
                    'idc'      =>$p->getTraslado()->getCurso()->getId(),
                    'codc'     =>$p->getTraslado()->getCurso()->getCodigo(),
                    'nombrec'  => $p->getTraslado()->getCurso()->getNombre()
                );
                    
            }else{

                $aprobados[] = array(
                    'idc'      =>$p->getOferta()->getCurso()->getId(),
                    'codc'     =>$p->getOferta()->getCurso()->getCodigo(),
                    'nombrec'  => $p->getOferta()->getCurso()->getNombre()
                );

            }

        }


        $aplazados = array();
        foreach ($cursosAplazados as $p ){

            if($p->getTraslado()){
                $aplazados[] = array(
                    'idc'      =>$p->getTraslado()->getCurso()->getId(),
                    'codc'     =>$p->getTraslado()->getCurso()->getCodigo(),
                    'nombrec'  => $p->getTraslado()->getCurso()->getNombre()
                );

            }else{

                $aplazados[] = array(
                    'idc'      =>$p->getOferta()->getCurso()->getId(),
                    'codc'     =>$p->getOferta()->getCurso()->getCodigo(),
                    'nombrec'  => $p->getOferta()->getCurso()->getNombre()
                );

            }

        }



        
        $plan = array();
        $asesoriasCol = array_column($asesorados, 'idc');
        //var_dump($asesoriasCol);die();
        foreach ($planestudios as $p ){
            $plan[] = array(
                    'idc'      =>$p->getCurso()->getId(),
                    'codc'     =>$p->getCurso()->getCodigo(),
                    'nombrec'  => $p->getCurso()->getNombre(),
                    'semestre'  =>$p->getSemestre(),
                    'uc'  =>$p->getCurso()->getUC(),
                    'check' =>  (in_array($p->getCurso()->getId(),$asesoriasCol) ) ? true : false 
                );
        }
        
        
        //die();
        
        
       
        
        //$serializer = \JMS\Serializer\SerializerBuilder   ::create()->build();
        //$jsonContent = $serializer->serialize($plan, 'json');
        
        return $this->render('AppBundle:Asesoria:asesoria.html.twig', array(
            'cursosofertados'=>$oferta,
            //'cursosAprobados'=>$cursosAprobados,
            'cursosAprobados'=>$aprobados,
            'cursosAplazados'=>$aplazados,
            'cursosInscritos'=>$cursosInscritos,
			'cursosasesorados'=>$asesorados,
            //'planesestudios'=> $jsonContent,
            'planesestudios'=> $plan,
            'config'=>$configPrograma,            
            'especialidad'=>$especialidad,
            'lapsoc'=>$lapso,
            'espe_estud'=>$espeestud,
	    'lapsocodigo'=>$lapsocodigo
        ));    
    }
    
    /**
     * @Route("/app/admin/estudiantes/process/asesoria/{lapso}", name="app_admin_estudiante_process_asesoria")
     */
    public function processAsesoriaEstudianteAction($lapso, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $data = json_decode($request->getContent(), true);
        $estudiante = $data['estudiante'];
        $cursos = $data['cursos'];
	//var_dump($data);die();
        $lapsoObj = $em->getRepository('AppBundle:Lapso')->find($lapso);
	$lapsoprueba = $em->getRepository('AppBundle:Lapso')->find($lapso);
        $espeestud = $em->getRepository('AppBundle:EspeEstud')->find($estudiante);
	
		
	 $cursosasesoradosant = $em->getRepository('AppBundle:Asesoria')->findBy(array('lapso'=>$lapsoObj,  'estudiante'=>$espeestud));
	
	  foreach ($cursosasesoradosant as $ase ){
		$this->deleteAsesoriaEstudianteAction($espeestud, $ase->getCurso()->getId(),$lapsoObj);
	  }	
		
        foreach ($cursos as $e ){
            $curso = $em->getRepository('AppBundle:Cursos')->find($e['idc']);
            $curso_isset = $em->getRepository('AppBundle:Asesoria')->findOneBy(array('lapso'=>$lapsoObj, 'curso'=>$curso, 'estudiante'=>$espeestud));
            if(!$curso_isset){
                $entity = new Asesoria();
                $entity->setEstudiante($espeestud);
                $entity->setCurso($curso);
                $entity->setLapso($lapsoObj);
		// $entity->setSessiones($lapsoprueba);
                $em->persist($entity);
            }
        }
		
        $em->flush();
		
		//cursos asesorados
		$cursosasesorados = $em->getRepository('AppBundle:Asesoria')->findBy(array('lapso'=>$lapsoObj,  'estudiante'=>$espeestud));
		
		 $data = array();
        foreach ($cursosasesorados as $p ){
            $data[] = array(
                    'idc'      =>$p->getCurso()->getId(),
                    'codc'     =>$p->getCurso()->getCodigo(),
                    'nombrec'  => $p->getCurso()->getNombre()
                );
        }
		
		
        /*$data = array(
            'mensaje' => 'Asesoria Guardada'
        );*/
        $respuesta = new Response(json_encode($data));
        $respuesta->headers->set('Content-Type', 'application/json');
        return $respuesta;   
 

        //return new \Symfony\Component\HttpFoundation\JsonResponse(json_encode($data), 200);
        
    }
    
    
    public function deleteAsesoriaEstudianteAction($estudiante, $curso,$lapso) {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $matricula = $em->getRepository('AppBundle:Asesoria')->findOneBy(array('estudiante'=>$estudiante, 'curso'=>$curso, 'lapso'=>$lapso));
        $em->remove($matricula);
        $em->flush();
		return true;
    }
    
    
    /**
     * @Route("/app/admin/estudiantes/planilla/asesoria/{id}/{lapso}/{lapsocodigo}", name="app_admin_estudiantes_planilla_asesoria")
     */
    public function reportPlanillaAsesoriaAction($id,$lapso,$lapsocodigo,Request $request){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);

	$subsede =$espe_estud->getSubsede();

       // $lapso = $em->getRepository('AppBundle:Lapso')->find($this->get('session')->get('lapsoActual')->getId());
        //$entities = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($espe_estud, $lapso);
		
		$entities = $em->getRepository('AppBundle:Asesoria')->findBy(array('lapso'=>$lapso,  'estudiante'=>$espe_estud));
        
	//  if ($entities){
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();    
	$pdf->profesor = $this->getUser()->getNombre();     
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(15,55,10,55,55));
        //srand(microtime()*1000000);        
        

	$headerPage = array('Sede'=>$subsede->getDescripcion(),'Nombre y Apellido'=>$espe_estud->getEstudiante(), 
                        'Cédula'=>$espe_estud->getEstudiante()->getCedula(),
                        'Especialidad'=>$espe_estud->getEspecialidad()->getNombre(),
                        );

        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Planilla de Registro Asesoría Académica - '.$lapsocodigo);
        $pdf->aligns = array('C', 'L', 'C', 'C', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Código', 'Nombre del Curso', 'UC', 'Tipo', 'Componente');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        
        foreach ($entities as $value){
            $ucs+=$value->getCurso()->getUc();
            $pdf->RowBorders(array($value->getCurso()->getCodigo(),
                                   $value->getCurso()->getNombre(),
                                   $value->getCurso()->getUc(),
                                   $value->getCurso()->getTipocursos()->getDescripcion(),
                                   $value->getCurso()->getComponentes()->getDescripcion()
                                   
                            ), 0);
        }
         $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(100, 6,'Total UC: ','T',0,'R');
        $pdf->Cell(10, 6,$ucs,'T',0,'C');
        $pdf->Cell(80, 6,'','T',1,'L');
        $pdf->SetFont('helvetica','B',9);
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
		
        $pdf->Cell(64,10,'',0,0,'C');
		$pdf->Ln(75);
		$pdf->SetX(74);
        $pdf->Cell(64,10,  utf8_decode('Cédula de Identidad, Apellidos y Nombres'),'T',0,'C');
		$pdf->Ln(5);
		$pdf->SetX(94);
        $pdf->Cell(64,10,  utf8_decode('Profesor Asesor'),0,null,'T',0,'C');
		
        //$pdf->Cell(63,10,'',0,1,'C');
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','planilla_registro_censo_asesoria.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
		
	 /* } else  {
		  
                $this->get('session')->getFlashBag()->add('msg-error', 'No posee asesoria académica en este lapso.!');
                return $this->redirect($this->generateUrl('app_admin_consul_estud_asesoria'));
		  
	  }*/
		  
		  
		  
		
    }
}
