<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="asesoria")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\AsesoriaRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class Asesoria {
 
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="EspeEstud", inversedBy="matricula")
     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")
     */
    protected $estudiante;
    
    
    /**
     * @ORM\ManyToOne(targetEntity="Cursos", inversedBy="oferacade")
     * @ORM\JoinColumn(name="curso_id", referencedColumnName="id")
     */
    protected $curso;
    
    /**
     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="oferacade")
     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")
     */
    protected $lapso;
    
    
    /**
     * @ORM\Column(type="date")
     */
    protected $fecharegistro;
    
    
    
    
    /**
     * @ORM\ManyToOne(targetEntity="Sessiones", inversedBy="matricula")
     * @ORM\JoinColumn(name="session_id", referencedColumnName="id")
     */
    protected $session;
    
    

    /**
     * @ORM\PrePersist()
     */
    public function setValue(){
        $this->setNota('1');
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nota
     *
     * @param integer $nota
     * @return Matricula
     */
    public function setNota($nota)
    {
        $this->nota = $nota;
    
        return $this;
    }

    /**
     * Get nota
     *
     * @return integer 
     */
    public function getNota()
    {
        return $this->nota;
    }

    /**
     * Set estudiante
     *
     * @param AppBundle\Entity\EspeEstud $estudiante
     * @return Matricula
     */
    public function setEstudiante(\AppBundle\Entity\EspeEstud $estudiante = null)
    {
        $this->estudiante = $estudiante;
    
        return $this;
    }

    /**
     * Get estudiante
     *
     * @return AppBundle\Entity\EspeEstud 
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }

    /**
     * Set oferta
     *
     * @param AppBundle\Entity\OfertAcade $oferta
     * @return Matricula
     */
    public function setOferta(\AppBundle\Entity\OfertAcade $oferta = null)
    {
        $this->oferta = $oferta;
    
        return $this;
    }

    /**
     * Get oferta
     *
     * @return AppBundle\Entity\OfertAcade 
     */
    public function getOferta()
    {
        return $this->oferta;
    }

    /**
     * Set condicion
     *
     * @param AppBundle\Entity\CondCurso $condicion
     * @return Matricula
     */
    public function setCondicion(\AppBundle\Entity\CondCurso $condicion = null)
    {
        $this->condicion = $condicion;
    
        return $this;
    }

    /**
     * Get condicion
     *
     * @return AppBundle\Entity\CondCurso 
     */
    public function getCondicion()
    {
        return $this->condicion;
    }

    /**
     * Set session
     *
     * @param \AppBundle\Entity\Sessiones $session
     * @return Matricula
     */
    public function setSession(\AppBundle\Entity\Sessiones $session = null)
    {
        $this->session = $session;
    
        return $this;
    }

    /**
     * Get session
     *
     * @return \AppBundle\Entity\Sessiones 
     */
    public function getSession()
    {
        return $this->session;
    }

    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->histmatri = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Add histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     *
     * @return Matricula
     */
    public function addHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri[] = $histmatri;

        return $this;
    }

    /**
     * Remove histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     */
    public function removeHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri->removeElement($histmatri);
    }

    /**
     * Get histmatri
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getHistmatri()
    {
        return $this->histmatri;
    }

    /**
     * Set fecharegistro
     *
     * @param \DateTime $fecharegistro
     *
     * @return Asesoria
     */
    public function setFecharegistro($fecharegistro)
    {
        $this->fecharegistro = $fecharegistro;

        return $this;
    }

    /**
     * Get fecharegistro
     *
     * @return \DateTime
     */
    public function getFecharegistro()
    {
        return $this->fecharegistro;
    }

    /**
     * Set curso
     *
     * @param \AppBundle\Entity\Cursos $curso
     *
     * @return Asesoria
     */
    public function setCurso(\AppBundle\Entity\Cursos $curso = null)
    {
        $this->curso = $curso;

        return $this;
    }

    /**
     * Get curso
     *
     * @return \AppBundle\Entity\Cursos
     */
    public function getCurso()
    {
        return $this->curso;
    }

    /**
     * Set lapso
     *
     * @param \AppBundle\Entity\Lapso $lapso
     *
     * @return Asesoria
     */
    public function setLapso(\AppBundle\Entity\Lapso $lapso = null)
    {
        $this->lapso = $lapso;

        return $this;
    }

    /**
     * Get lapso
     *
     * @return \AppBundle\Entity\Lapso
     */
    public function getLapso()
    {
        return $this->lapso;
    }
    
    /**
     * @ORM\PrePersist
     */
    public function setCreateAt(){
        $this->fecharegistro = new \DateTime();
        
    }
            
    
}
