<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="auditoria")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\AuditoriaRepository")
 */
class Auditoria {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="EspeEstud", inversedBy="auditoria")
     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")
     */
    protected $estudiante;

    /**
     * @ORM\ManyToOne(targetEntity="Usuarios", inversedBy="auditoria")
     * @ORM\JoinColumn(name="usuario_id", referencedColumnName="id")
     */

    protected $usuarios;
    
    /**
     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="auditoria")
     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")
     */
    protected $lapso;
    
    /**
     * @ORM\ManyToOne(targetEntity="Cursos", inversedBy="auditoria")
     * @ORM\JoinColumn(name="curso_id", referencedColumnName="id")
     */
    protected $curso;
    
    /**
     * @ORM\Column(type="string", length=20)
     */
    protected $seccion;
    

    
    /**
     * @ORM\Column(type="integer", length=2)
     */
    protected $nota;
    
    /**
     * @ORM\ManyToOne(targetEntity="CondCurso", inversedBy="auditoria")
     * @ORM\JoinColumn(name="condicion_id", referencedColumnName="id")
     */
    protected $condicion;
    
     /**
     * @ORM\Column(type="datetime")
     */
     protected $fecha_hora;

    
    /**
     * @ORM\Column(type="string")
     */
    protected $proceso;
    
    /**
     * @ORM\ManyToOne(targetEntity="Programa", inversedBy="auditoria")
     * @ORM\JoinColumn(name="programa_id", referencedColumnName="id")
     */
    protected $programa;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="auditoria")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;
    
    /**
     * @ORM\ManyToOne(targetEntity="Especialidad", inversedBy="auditoria")
     * @ORM\JoinColumn(name="especialidad_id", referencedColumnName="id")
     */
    protected $especialidad;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sessiones", inversedBy="auditoria")
     * @ORM\JoinColumn(name="session_id", referencedColumnName="id")
     */
    protected $session;
    
    /**
     * @ORM\ManyToOne(targetEntity="Matricula", inversedBy="auditoria")
     * @ORM\JoinColumn(name="matricula_id", referencedColumnName="id")
     */
    protected $matricula;


    // METODOS GENERADOS PARA LAS CONSULTAS //
    

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set seccion
     *
     * @param string $seccion
     * @return Auditoria
     */
    public function setSeccion($seccion)
    {
        $this->seccion = $seccion;
    
        return $this;
    }

    /**
     * Get seccion
     *
     * @return string 
     */
    public function getSeccion()
    {
        return $this->seccion;
    }



    /**
     * Set nota
     *
     * @param integer $nota
     * @return Auditoria
     */
    public function setNota($nota)
    {
        $this->nota = $nota;
    
        return $this;
    }

    /**
     * Get nota
     *
     * @return integer 
     */
    public function getNota()
    {
        return $this->nota;
    }

   /**
     * Set fecha_hora
     *
     * @param \DateTime $fechaHora
     * @return Estudiante
     */
      public function setFechaHora($fechaHora)
      {
          $this->fecha_hora = $fechaHora;
      
          return $this;
      }
      
     /**
      * Get fecha_hora
      *
      * @return \DateTime 
      */
      public function getFechaHora()
      {
          return $this->fecha_hora;
      }

    /**
     * Set proceso
     *
     * @param string $proceso
     * @return Auditoria
     */
    public function setProceso($proceso)
    {
        $this->proceso = $proceso;
    
        return $this;
    }

    /**
     * Get proceso
     *
     * @return string 
     */
    public function getProceso()
    {
        return $this->proceso;
    }

    /**
     * Set usuarios
     *
     * @param AppBundle\Entity\Usuarios $usuarios
     * @return Auditoria
     */
    public function setUsuario(\AppBundle\Entity\Usuarios $usuarios = null)
    {
        $this->usuarios = $usuarios;
    
        return $this;
    }

    /**
     * Get usuarios
     *
     * @return AppBundle\Entity\Usuarios
     */
    public function getUsuarios()
    {
        return $this->usuarios;
    }

  /**
     * Set estudiante
     *
     * @param AppBundle\Entity\EspeEstud $estudiante
     * @return Auditoria
     */
    public function setEstudiante(\AppBundle\Entity\EspeEstud $estudiante = null)
    {
        $this->estudiante = $estudiante;
    
        return $this;
    }

    /**
     * Get estudiante
     *
     * @return AppBundle\Entity\EspeEstud 
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }



    /**
     * Set lapso
     *
     * @param AppBundle\Entity\Lapso $lapso
     * @return Auditoria
     */
    public function setLapso(\AppBundle\Entity\Lapso $lapso = null)
    {
        $this->lapso = $lapso;
    
        return $this;
    }

    /**
     * Get lapso
     *
     * @return AppBundle\Entity\Lapso 
     */
    public function getLapso()
    {
        return $this->lapso;
    }

    /**
     * Set curso
     *
     * @param AppBundle\Entity\Cursos $curso
     * @return Auditoria
     */
    public function setCurso(\AppBundle\Entity\Cursos $curso = null)
    {
        $this->curso = $curso;
    
        return $this;
    }

    /**
     * Get curso
     *
     * @return AppBundle\Entity\Cursos 
     */
    public function getCurso()
    {
        return $this->curso;
    }

    /**
     * Set condicion
     *
     * @param AppBundle\Entity\CondCurso $condicion
     * @return Auditoria
     */
    public function setCondicion(\AppBundle\Entity\CondCurso $condicion = null)
    {
        $this->condicion = $condicion;
    
        return $this;
    }

    /**
     * Get condicion
     *
     * @return AppBundle\Entity\CondCurso 
     */
    public function getCondicion()
    {
        return $this->condicion;
    }

    /**
     * Set programa
     *
     * @param AppBundle\Entity\Programa $programa
     * @return Auditoria
     */
    public function setPrograma(\AppBundle\Entity\Programa $programa = null)
    {
        $this->programa = $programa;
    
        return $this;
    }

    /**
     * Get programa
     *
     * @return AppBundle\Entity\Programa 
     */
    public function getPrograma()
    {
        return $this->programa;
    }

    /**
     * Set sede
     *
     * @param AppBundle\Entity\Sede $sede
     * @return Auditoria
     */
    public function setSede(\AppBundle\Entity\Sede $sede = null)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return AppBundle\Entity\Sede 
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Set especialidad
     *
     * @param AppBundle\Entity\Especialidad $especialidad
     * @return Auditoria
     */
    public function setEspecialidad(\AppBundle\Entity\Especialidad $especialidad = null)
    {
        $this->especialidad = $especialidad;
    
        return $this;
    }

    /**
     * Get especialidad
     *
     * @return AppBundle\Entity\Especialidad 
     */
    public function getEspecialidad()
    {
        return $this->especialidad;
    }

    /**
     * Set session
     *
     * @param \AppBundle\Entity\Sessiones $session
     * @return Auditoria
     */
    public function setSession(\AppBundle\Entity\Sessiones $session = null)
    {
        $this->session = $session;
    
        return $this;
    }

    /**
     * Get session
     *
     * @return \AppBundle\Entity\Sessiones 
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * Set matricula
     *
     * @param \AppBundle\Entity\Matricula $matricula
     *
     * @return Auditoria
     */
    public function setMatricula(\AppBundle\Entity\Matricula $matricula = null)
    {
        $this->matricula = $matricula;

        return $this;
    }

    /**
     * Get matricula
     *
     * @return \AppBundle\Entity\Matricula
     */
    public function getMatricula()
    {
        return $this->matricula;
    }
}
