<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\PrelacionRepository")
 * @ORM\Table(name="prelacion")
 */
class Prelacion {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\PlanEstudio", inversedBy="prelacion")
     * @ORM\JoinColumn(name="plan_id", referencedColumnName="id")
     */
    protected $plan;
    
    /**
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Cursos", inversedBy="prelacion")
     * @ORM\JoinColumn(name="curso_id", referencedColumnName="id")
     */
    protected $curso;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set plan
     *
     * @param \AppBundle\Entity\PlanEstudio $plan
     *
     * @return Prelacion
     */
    public function setPlan(\AppBundle\Entity\PlanEstudio $plan = null)
    {
        $this->plan = $plan;

        return $this;
    }

    /**
     * Get plan
     *
     * @return \AppBundle\Entity\PlanEstudio
     */
    public function getPlan()
    {
        return $this->plan;
    }

    /**
     * Set curso
     *
     * @param \AppBundle\Entity\Cursos $curso
     *
     * @return Prelacion
     */
    public function setCurso(\AppBundle\Entity\Cursos $curso = null)
    {
        $this->curso = $curso;

        return $this;
    }

    /**
     * Get curso
     *
     * @return \AppBundle\Entity\Cursos
     */
    public function getCurso()
    {
        return $this->curso;
    }
}
