<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="sessiones")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\SessionesRepository")
 * @ORM\HasLifecycleCallbacks()
 */   
class Sessiones {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="Usuarios", inversedBy="session")
     * @ORM\JoinColumn(name="usuario_id", referencedColumnName="id")
     */
    protected $usuario;
    
    /**
     * @ORM\ManyToOne(targetEntity="Estudiante", inversedBy="session")
     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")
     */
    protected $usuario_alum;
    
    /**
     * @ORM\OneToMany(targetEntity="OfertAcade", mappedBy="session")
     */
    protected $oferacade;
    
    /**
     * @ORM\OneToMany(targetEntity="HistMatri", mappedBy="session")
     */
    protected $histmatri;
    
    /**
     * @ORM\OneToMany(targetEntity="HistMatriEgresado", mappedBy="session")
     */
    protected $histmatriegresado;
    
    /**
     * @ORM\OneToMany(targetEntity="Matricula", mappedBy="session")
     */
    protected $matricula;
    
    /**
     * @ORM\OneToMany(targetEntity="Depositos", mappedBy="session")
     */
    protected $depositos;

    /**
     * @ORM\OneToMany(targetEntity="SessionesDetalles", mappedBy="session")
     */
    protected $sessiondet;
    
    /**
     * @ORM\Column(type="datetime")
     */
    protected $fecha;
    
    

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->oferacade = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatri = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatriegresado = new \Doctrine\Common\Collections\ArrayCollection();
        $this->matricula = new \Doctrine\Common\Collections\ArrayCollection();
        $this->depositos = new \Doctrine\Common\Collections\ArrayCollection();
        $this->sessiondet = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * @ORM\PrePersist()
     */
    
    public function setValueFecha(){
        $this->fecha = new \DateTime();
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set fecha
     *
     * @param \DateTime $fecha
     * @return Sessiones
     */
    public function setFecha($fecha)
    {
        $this->fecha = $fecha;
    
        return $this;
    }

    /**
     * Get fecha
     *
     * @return \DateTime 
     */
    public function getFecha()
    {
        return $this->fecha;
    }

    /**
     * Set usuario
     *
     * @param \AppBundle\Entity\Usuarios $usuario
     * @return Sessiones
     */
    public function setUsuario(\AppBundle\Entity\Usuarios $usuario = null)
    {
        $this->usuario = $usuario;
    
        return $this;
    }

    /**
     * Get usuario
     *
     * @return \AppBundle\Entity\Usuarios 
     */
    public function getUsuario()
    {
        return $this->usuario;
    }

    /**
     * Set usuario_alum
     *
     * @param \AppBundle\Entity\Estudiante $usuarioAlum
     * @return Sessiones
     */
    public function setUsuarioAlum(\AppBundle\Entity\Estudiante $usuarioAlum = null)
    {
        $this->usuario_alum = $usuarioAlum;
    
        return $this;
    }

    /**
     * Get usuario_alum
     *
     * @return \AppBundle\Entity\Estudiante 
     */
    public function getUsuarioAlum()
    {
        return $this->usuario_alum;
    }

    /**
     * Add oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     * @return Sessiones
     */
    public function addOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade[] = $oferacade;
    
        return $this;
    }

    /**
     * Remove oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     */
    public function removeOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade->removeElement($oferacade);
    }

    /**
     * Get oferacade
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getOferacade()
    {
        return $this->oferacade;
    }

    /**
     * Add histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     * @return Sessiones
     */
    public function addHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri[] = $histmatri;
    
        return $this;
    }

    /**
     * Remove histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     */
    public function removeHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri->removeElement($histmatri);
    }

    /**
     * Get histmatri
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHistmatri()
    {
        return $this->histmatri;
    }

    /**
     * Add histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     * @return Sessiones
     */
    public function addHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado[] = $histmatriegresado;
    
        return $this;
    }

    /**
     * Remove histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     */
    public function removeHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado->removeElement($histmatriegresado);
    }

    /**
     * Get histmatriegresado
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHistmatriegresado()
    {
        return $this->histmatriegresado;
    }

    /**
     * Add matricula
     *
     * @param \AppBundle\Entity\Matricula $matricula
     * @return Sessiones
     */
    public function addMatricula(\AppBundle\Entity\Matricula $matricula)
    {
        $this->matricula[] = $matricula;
    
        return $this;
    }

    /**
     * Remove matricula
     *
     * @param \AppBundle\Entity\Matricula $matricula
     */
    public function removeMatricula(\AppBundle\Entity\Matricula $matricula)
    {
        $this->matricula->removeElement($matricula);
    }

    /**
     * Get matricula
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getMatricula()
    {
        return $this->matricula;
    }

    /**
     * Add depositos
     *
     * @param \AppBundle\Entity\Depositos $depositos
     * @return Sessiones
     */
    public function addDeposito(\AppBundle\Entity\Depositos $depositos)
    {
        $this->depositos[] = $depositos;
    
        return $this;
    }

    /**
     * Remove depositos
     *
     * @param \AppBundle\Entity\Depositos $depositos
     */
    public function removeDeposito(\AppBundle\Entity\Depositos $depositos)
    {
        $this->depositos->removeElement($depositos);
    }

    /**
     * Get depositos
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getDepositos()
    {
        return $this->depositos;
    }

    /**
     * Add sessiondet
     *
     * @param \AppBundle\Entity\SessionesDetalles $sessiondet
     * @return Sessiones
     */
    public function addSessiondet(\AppBundle\Entity\SessionesDetalles $sessiondet)
    {
        $this->sessiondet[] = $sessiondet;
    
        return $this;
    }

    /**
     * Remove sessiondet
     *
     * @param \AppBundle\Entity\SessionesDetalles $sessiondet
     */
    public function removeSessiondet(\AppBundle\Entity\SessionesDetalles $sessiondet)
    {
        $this->sessiondet->removeElement($sessiondet);
    }

    /**
     * Get sessiondet
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSessiondet()
    {
        return $this->sessiondet;
    }
}
