<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="sub_items")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\SubItemRepository")
 */
class SubItem {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $subitem;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $router;


    /**
     * @ORM\ManyToOne(targetEntity="Item", inversedBy="subitem")
     * @ORM\JoinColumn(name="item_id", referencedColumnName="id")
     */
    protected $item;
        
    /**
     * @ORM\OneToMany(targetEntity="MenuUsuario", mappedBy="subitem")
     */
    protected $menusu;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $icono;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set subitem
     *
     * @param string $subitem
     * @return SubItem
     */
    public function setSubitem($subitem)
    {
        $this->subitem = $subitem;
    
        return $this;
    }

    /**
     * Get subitem
     *
     * @return string 
     */
    public function getSubitem()
    {
        return $this->subitem;
    }

    /**
     * Set item
     *
     * @param \AppBundle\Entity\Item $item
     * @return SubItem
     */
    public function setItem(\AppBundle\Entity\Item $item = null)
    {
        $this->item = $item;
    
        return $this;
    }

    /**
     * Get item
     *
     * @return \AppBundle\Entity\Item 
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->menusu = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add menusu
     *
     * @param \AppBundle\Entity\MenuUsuario $menusu
     * @return SubItem
     */
    public function addMenusu(\AppBundle\Entity\MenuUsuario $menusu)
    {
        $this->menusu[] = $menusu;
    
        return $this;
    }

    /**
     * Remove menusu
     *
     * @param \AppBundle\Entity\MenuUsuario $menusu
     */
    public function removeMenusu(\AppBundle\Entity\MenuUsuario $menusu)
    {
        $this->menusu->removeElement($menusu);
    }

    /**
     * Get menusu
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getMenusu()
    {
        return $this->menusu;
    }

    /**
     * Set router
     *
     * @param string $router
     * @return SubItem
     */
    public function setRouter($router)
    {
        $this->router = $router;
    
        return $this;
    }

    public function __toString() {
        return $this->getSubitem();
    }
    
    /**
     * Get router
     *
     * @return string 
     */
    public function getRouter()
    {
        return $this->router;
    }
    
    /**
     * Set icono
     *
     * @param string $icono
     *
     * @return SubItem
     */
    public function setIcono($icono)
    {
        $this->icono = $icono;

        return $this;
    }

    /**
     * Get icono
     *
     * @return string
     */
    public function getIcono()
    {
        return $this->icono;
    }
    
}
