<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="universidades")
 * @ORM\Entity()
 */
class Universidades {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=20, unique=true)
     */
    protected $codigo;
    
    /**
     * @ORM\Column(type="string", length=100)
     */
    protected $nombre;
    
    /**
     * @ORM\Column(type="string", length=100)
     */
    protected $ubicacion;
    
    /**
     * @ORM\Column(type="string", length=10, nullable=true)
     */
    protected $siglas;
    
    /**
     * @ORM\Column(type="string", length=20, nullable=true)
     */
    protected $dependencia;
    
    /**
     * @ORM\OneToMany(targetEntity="Estudiante", mappedBy="universidad")
     */
    protected $estudiante;

    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     * @return Universidades
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    
        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     * @return Universidades
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    
        return $this;
    }

    /**
     * Get nombre
     *
     * @return string 
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set ubicacion
     *
     * @param string $ubicacion
     * @return Universidades
     */
    public function setUbicacion($ubicacion)
    {
        $this->ubicacion = $ubicacion;
    
        return $this;
    }

    /**
     * Get ubicacion
     *
     * @return string 
     */
    public function getUbicacion()
    {
        return $this->ubicacion;
    }

    /**
     * Set siglas
     *
     * @param string $siglas
     * @return Universidades
     */
    public function setSiglas($siglas)
    {
        $this->siglas = $siglas;
    
        return $this;
    }

    /**
     * Get siglas
     *
     * @return string 
     */
    public function getSiglas()
    {
        return $this->siglas;
    }

    /**
     * Set dependencia
     *
     * @param string $dependencia
     * @return Universidades
     */
    public function setDependencia($dependencia)
    {
        $this->dependencia = $dependencia;
    
        return $this;
    }

    /**
     * Get dependencia
     *
     * @return string 
     */
    public function getDependencia()
    {
        return $this->dependencia;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->estudiante = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add estudiante
     *
     * @param \AppBundle\Entity\Estudiante $estudiante
     * @return Universidades
     */
    public function addEstudiante(\AppBundle\Entity\Estudiante $estudiante)
    {
        $this->estudiante[] = $estudiante;
    
        return $this;
    }

    /**
     * Remove estudiante
     *
     * @param \AppBundle\Entity\Estudiante $estudiante
     */
    public function removeEstudiante(\AppBundle\Entity\Estudiante $estudiante)
    {
        $this->estudiante->removeElement($estudiante);
    }

    /**
     * Get estudiante
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }
    
    public function __toString() {
        return $this->getNombre().' - '.$this->getUbicacion() .' ('.$this->getSiglas().')  ';
    }
}
