<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;

class ProfesorType extends AbstractType
{
    
    private $em;
    
    public function __construct(EntityManager $em) {
        $this->em = $em;
    }
    
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('cedula')
            ->add('primer_nombre')
            ->add('segundo_nombre')
            ->add('primer_apellido')
            ->add('segundo_apellido')
            ->add('nacionalidad')
            ->add('fecha_nacimiento','date', array(
                'input' => 'datetime',
                'widget'=> 'single_text',
                'format'=> 'dd-MM-yyyy',
                'required'=>true,
                'attr' => array('placeholder' => 'dd-mm-yyyy')
             ))
            ->add('lugar_nacimiento')
            ->add('sexo', 'choice', array('empty_value'=>'.:Seleccione:.','choices'=>array('f'=>'Femenino', 'm'=>'Masculino')))
            ->add('estado_civil', 'choice', array('empty_value'=>'.:Seleccione:.','choices'=>array('s'=>'Soltero(a)', 'c'=>'Casado(a)', 'd'=>'Divorciado(a)', 'v'=>'Viudo(a)')))
            ->add('direccion')
            ->add('telefono_movil')
            ->add('telefono_local')
            ->add('email')
            //->add('salf')
            ->add('password')
            //->add('sede')
            ->add('activo', 'checkbox', array('required'=>false,'attr'=>array('class'=>'checkbox-inline')))
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Profesor'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'appbundle_profesor';
    }
}
