<?php
namespace AppBundle\Utils;

use Revista\AppBundle\Entity\RecuperarPass;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;

class Util {
    
    private $container;
    
    public function __construct(Container $container){
        $this->container = $container;
    }
    
    public function generarLinkTemporal($users, $username, $em)
    {
        $cadena = $users->getId().$username.rand(1, 999999).date('Y-m-d');
        $token = sha1($cadena);        
        
        
        $RecuperarPass = new RecuperarPass();
        $RecuperarPass->setUsers($users);
        $RecuperarPass->setUsername($username);
        $RecuperarPass->setToken($token);
        $RecuperarPass->setCreated(new \DateTime());
        
        $em->persist($RecuperarPass);
        $em->flush();
        
        $enlace = $_SERVER['SERVER_NAME'].'/recordmypass/restablecer/?idusers='.sha1($users->getId()).'&token='.$token;
        return $enlace;
    }
    
    public function enviarEmail($email, $link){
        
        $mnsj = '<html>
                    <head>
                    <title>Restablece tu contraseña</title>
                    </head>
                    <body>
                    <p>Hemos recibido una petición para restablecer la contraseña de tu cuenta.</p>
                    <p>Si hiciste esta petición, haz clic en el siguiente enlace, si no hiciste esta petición puedes ignorar este correo.</p>
                    <p>
                        <strong>Enlace para restablecer tu contraseña</strong><br>
                        <a href="'.$link.'"> Restablecer contraseña </a>
                    </p>
                    </body>
                    </html>';
        
        $mensaje = \Swift_Message::newInstance()
                ->setSubject('Restablecer Contraseña')
                ->setFrom('infor@revista.praecones.org')
                ->setTo($email)
                ->setBody($mnsj, 'text/html');
        
        if($this->container->get('mailer')->send($mensaje)){
            return true;
        }
        
        return false;   
    }

    
}

