<?php

namespace UsersBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="subsede_user")
 * @ORM\Entity(repositoryClass="UsersBundle\Entity\Repository\subsedeuserRepository")
 */
class SubSedeUser {
 
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @ORM\ManyToOne(targetEntity="Users", inversedBy="subsedeuser")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;
    
    /**
     * @ORM\ManyToOne(targetEntity="SubSede", inversedBy="subsedeuser")
     * @ORM\JoinColumn(name="subsede_id", referencedColumnName="id")
     */
    protected $subsede;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set user
     *
     * @param \UsersBundle\Entity\Users $user
     *
     * @return SubSedeUser
     */
    public function setUser(\UsersBundle\Entity\Users $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \UsersBundle\Entity\Users
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set subsede
     *
     * @param \UsersBundle\Entity\SubSede $subsede
     *
     * @return SubSedeUser
     */
    public function setSubsede(\UsersBundle\Entity\SubSede $subsede = null)
    {
        $this->subsede = $subsede;

        return $this;
    }

    /**
     * Get subsede
     *
     * @return \UsersBundle\Entity\SubSede
     */
    public function getSubsede()
    {
        return $this->subsede;
    }
}
